/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCEventHandler;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.MutablePair;

public class PortableTunePlayerItem
extends Item {
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        SonicSecuritySystemBlockEntity te;
        if (world.func_180495_p(pos).func_177230_c() == SCContent.sonicSecuritySystem && ((te = (SonicSecuritySystemBlockEntity)world.func_175625_s(pos)).isOwnedBy((Entity)player) || te.isAllowed((Entity)player))) {
            if (te.getNumberOfNotes() > 0) {
                ItemStack stack = player.func_184586_b(hand);
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                te.saveNotes(stack.func_77978_p());
                player.func_146105_b((ITextComponent)Utils.localize("messages.securitycraft:portable_tune_player.tune_saved", new Object[0]), true);
            } else {
                player.func_146105_b((ITextComponent)Utils.localize("messages.securitycraft:portable_tune_player.no_tune", new Object[0]), true);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound tag = stack.func_77978_p();
            boolean isTunePlaying = SCEventHandler.PLAYING_TUNES.containsKey(player);
            if (!isTunePlaying && tag.func_74764_b("Notes")) {
                ArrayDeque notes = new ArrayDeque();
                SonicSecuritySystemBlockEntity.loadNotes(tag, notes);
                SCEventHandler.PLAYING_TUNES.put(player, (MutablePair<Integer, Deque<SonicSecuritySystemBlockEntity.NoteWrapper>>)MutablePair.of((Object)0, notes));
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            if (isTunePlaying) {
                SCEventHandler.PLAYING_TUNES.remove(player);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        int notesCount = stack.func_77978_p().func_150295_c("Notes", 10).func_74745_c();
        if (notesCount > 0) {
            tooltip.add(Utils.localize("tooltip.securitycraft.component.notes", notesCount).func_150255_a(Utils.GRAY_STYLE).func_150254_d());
        }
    }
}

