/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.misc.GlobalPos;
import net.geforcemods.securitycraft.misc.LinkingStateItemPropertyHandler;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class CameraMonitorItem
extends Item {
    public CameraMonitorItem() {
        this.func_185043_a(LinkingStateItemPropertyHandler.LINKING_STATE_PROPERTY, LinkingStateItemPropertyHandler::cameraMonitor);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.func_180495_p(pos).func_177230_c() == SCContent.securityCamera && !PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)player)) {
            SecurityCameraBlockEntity te = (SecurityCameraBlockEntity)world.func_175625_s(pos);
            if (!te.isOwnedBy((Entity)player) && !te.isAllowed((Entity)player)) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:cameraMonitor.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:cameraMonitor.cannotView", new Object[0]), TextFormatting.RED);
                return EnumActionResult.SUCCESS;
            }
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            GlobalPos view = GlobalPos.of(player.field_71093_bK, pos);
            if (CameraMonitorItem.isCameraAdded(stack.func_77978_p(), view)) {
                stack.func_77978_p().func_82580_o(CameraMonitorItem.getTagNameFromPosition(stack.func_77978_p(), view));
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:cameraMonitor.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:cameraMonitor.unbound", pos), TextFormatting.RED);
                return EnumActionResult.SUCCESS;
            }
            for (int i = 1; i <= 30; ++i) {
                if (stack.func_77978_p().func_74764_b("Camera" + i)) continue;
                stack.func_77978_p().func_74778_a("Camera" + i, view.toNBTString());
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:cameraMonitor.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:cameraMonitor.bound", pos), TextFormatting.GREEN);
                break;
            }
            if (!world.field_72995_K) {
                SecurityCraft.network.sendTo((IMessage)new UpdateNBTTagOnClient(stack), (EntityPlayerMP)player);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_77942_o()) {
            if (!CameraMonitorItem.hasCameraAdded(stack.func_77978_p())) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:cameraMonitor.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:cameraMonitor.rightclickToView", new Object[0]), TextFormatting.RED);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
        } else {
            this.updateTagWithNames(stack, world);
        }
        player.openGui((Object)SecurityCraft.instance, ScreenHandler.Screens.CAMERA_MONITOR.ordinal(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (stack.func_77978_p() == null) {
            return;
        }
        tooltip.add(Utils.localize("tooltip.securitycraft:cameraMonitor", CameraMonitorItem.getNumberOfCamerasBound(stack.func_77978_p()) + "/30").func_150255_a(Utils.GRAY_STYLE).func_150254_d());
    }

    public static String getTagNameFromPosition(NBTTagCompound tag, GlobalPos view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!tag.func_74764_b("Camera" + i) || !view.checkCoordinates(coords = tag.func_74779_i("Camera" + i).split(" "))) continue;
            return "Camera" + i;
        }
        return "";
    }

    public static boolean hasCameraAdded(NBTTagCompound tag) {
        if (tag == null) {
            return false;
        }
        for (int i = 1; i <= 30; ++i) {
            if (!tag.func_74764_b("Camera" + i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCameraAdded(NBTTagCompound tag, GlobalPos view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!tag.func_74764_b("Camera" + i) || !view.checkCoordinates(coords = tag.func_74779_i("Camera" + i).split(" "))) continue;
            return true;
        }
        return false;
    }

    public static void removeCameraOnClient(int camID, NBTTagCompound stackTag) {
        if (stackTag != null) {
            stackTag.func_82580_o(CameraMonitorItem.getTagNameFromPosition(stackTag, (GlobalPos)CameraMonitorItem.getCameraPositions(stackTag).get(camID - 1).getLeft()));
        }
        SecurityCraft.network.sendToServer((IMessage)new RemoveCameraTag(camID));
    }

    public static List<Pair<GlobalPos, String>> getCameraPositions(NBTTagCompound tag) {
        ArrayList<Pair<GlobalPos, String>> list = new ArrayList<Pair<GlobalPos, String>>();
        for (int i = 1; i <= 30; ++i) {
            if (tag != null && tag.func_74764_b("Camera" + i)) {
                String[] coords = tag.func_74779_i("Camera" + i).split(" ");
                String nameKey = "camera" + i + "_name";
                String cameraName = null;
                if (tag.func_74764_b(nameKey)) {
                    cameraName = tag.func_74779_i(nameKey);
                }
                list.add((Pair<GlobalPos, String>)Pair.of((Object)GlobalPos.of(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]), coords.length == 4 ? Integer.parseInt(coords[3]) : 0), (Object)cameraName));
                continue;
            }
            list.add((Pair<GlobalPos, String>)Pair.of(null, null));
        }
        return list;
    }

    public static int getNumberOfCamerasBound(NBTTagCompound tag) {
        if (tag == null) {
            return 0;
        }
        int amount = 0;
        for (int i = 1; i <= 31; ++i) {
            if (!tag.func_74764_b("Camera" + i)) continue;
            ++amount;
        }
        return amount;
    }

    private void updateTagWithNames(ItemStack stack, World level) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        for (int i = 1; i <= 30; ++i) {
            BlockPos camPos;
            String cameraString = tag.func_74779_i("Camera" + i);
            String[] globalPos = cameraString.split(" ");
            String nameKey = "camera" + i + "_name";
            if (globalPos.length != 3 && (globalPos.length != 4 || level.field_73011_w.getDimension() != Integer.parseInt(globalPos[3])) || !level.func_175667_e(camPos = new BlockPos(Integer.parseInt(globalPos[0]), Integer.parseInt(globalPos[1]), Integer.parseInt(globalPos[2])))) continue;
            TileEntity be = level.func_175625_s(camPos);
            if (be instanceof SecurityCameraBlockEntity && ((SecurityCameraBlockEntity)be).func_145818_k_()) {
                tag.func_74778_a(nameKey, ((SecurityCameraBlockEntity)be).func_70005_c_());
                continue;
            }
            tag.func_82580_o(nameKey);
        }
    }
}

