/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.CameraFeed;
import net.geforcemods.securitycraft.entity.camera.CameraViewAreaExtension;
import net.geforcemods.securitycraft.misc.GlobalPos;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiVideoSettings;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="securitycraft", value={Side.CLIENT})
public class FrameFeedHandler {
    private static final Map<GlobalPos, CameraFeed> FRAME_CAMERA_FEEDS = new ConcurrentHashMap<GlobalPos, CameraFeed>();
    private static GlobalPos currentlyCapturedCamera;
    private static Frustum lastUsedFrustum;
    private static double lastFrameRendered;

    @SubscribeEvent
    public static void onRenderFramePost(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || player.field_70170_p == null || !FrameFeedHandler.hasFeeds() || !ConfigHandler.frameFeedViewingEnabled || mc.field_71462_r instanceof GuiVideoSettings) {
            return;
        }
        Profiler profiler = mc.field_71424_I;
        double currentTime = (double)System.nanoTime() / 1.0E9;
        Map<GlobalPos, CameraFeed> activeFrameCameraFeeds = FrameFeedHandler.getFeedsToRender(currentTime);
        if (activeFrameCameraFeeds.isEmpty()) {
            return;
        }
        lastFrameRendered = currentTime;
        profiler.func_76319_b();
        profiler.func_76320_a("gameRenderer");
        profiler.func_76320_a("securitycraft:frame_level");
        World level = player.field_70170_p;
        float partialTick = mc.func_147113_T() ? mc.field_193996_ah : event.renderTickTime;
        Entity oldCamEntity = mc.func_175606_aa();
        int oldWidth = mc.field_71443_c;
        int oldHeight = mc.field_71440_d;
        int frameFeedResolution = ConfigHandler.frameFeedResolution;
        ObjectArrayList oldVisibleSections = new ObjectArrayList((Collection)mc.field_71438_f.field_72755_R);
        int newFrameFeedViewDistance = FrameFeedHandler.getFrameFeedViewDistance(null);
        float oldXRot = player.field_70726_aT;
        float oldXRotO = player.field_70727_aS;
        float oldYRot = player.field_71109_bG;
        float oldYRotO = player.field_71107_bF;
        float oldEyeHeight = player.eyeHeight;
        boolean oldRenderHand = mc.field_71460_t.field_175074_C;
        boolean oldRenderBlockOutline = mc.field_71460_t.field_175073_D;
        int oldCameraType = mc.field_71474_y.field_74320_O;
        EntityArmorStand securityCamera = new EntityArmorStand(level);
        Frustum playerFrustum = FrameFeedHandler.prepareFrustum(oldCamEntity);
        Framebuffer oldMainRenderTarget = mc.func_147110_a();
        mc.field_71460_t.field_175073_D = false;
        mc.field_71460_t.field_175074_C = false;
        mc.field_71443_c = frameFeedResolution;
        mc.field_71440_d = frameFeedResolution;
        mc.field_71474_y.field_74320_O = 0;
        for (Map.Entry<GlobalPos, CameraFeed> cameraView : activeFrameCameraFeeds.entrySet()) {
            BlockPos pos;
            TileEntity te;
            GlobalPos cameraPos = cameraView.getKey();
            CameraFeed feed = cameraView.getValue();
            if (feed.usesVbo() != OpenGlHelper.func_176075_f()) {
                FrameFeedHandler.refreshCameraFeed(cameraPos);
                continue;
            }
            if (cameraPos.dimension() != level.field_73011_w.getDimension() || !((te = level.func_175625_s(pos = cameraPos.pos())) instanceof SecurityCameraBlockEntity) || playerFrustum != null && !feed.hasFrameInFrustum(playerFrustum)) continue;
            SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)te;
            Framebuffer frameTarget = feed.renderTarget();
            Vec3d cameraEntityPos = new Vec3d((double)pos.func_177958_n() + 0.5, (double)((float)pos.func_177956_o() - player.func_70047_e()) + 0.5, (double)pos.func_177952_p() + 0.5);
            float cameraXRot = be.getDefaultXRotation();
            float cameraYRot = be.getDefaultYRotation((EnumFacing)be.func_145831_w().func_180495_p(be.func_174877_v()).func_177229_b((IProperty)SecurityCameraBlock.FACING)) + (float)Utils.lerp((double)partialTick, be.getOriginalCameraRotation(), be.getCameraRotation()) * 57.295776f;
            securityCamera.func_70107_b(cameraEntityPos.field_72450_a, cameraEntityPos.field_72448_b, cameraEntityPos.field_72449_c);
            mc.func_175607_a((Entity)securityCamera);
            securityCamera.field_70125_A = cameraXRot;
            securityCamera.field_70177_z = cameraYRot;
            securityCamera.field_70127_C = cameraXRot;
            securityCamera.field_70126_B = cameraYRot;
            currentlyCapturedCamera = cameraPos;
            feed.applyVisibleSections(mc.field_71438_f.field_72755_R, mc.field_71438_f.field_175009_l);
            profiler.func_76320_a("securitycraft:discover_frame_sections");
            feed.discoverVisibleSections(cameraPos, newFrameFeedViewDistance);
            mc.field_71438_f.field_175009_l.addAll(feed.getDirtyRenderChunks());
            profiler.func_76318_c("securitycraft:bind_frame_target");
            frameTarget.func_147614_f();
            frameTarget.func_147610_a(true);
            mc.field_147124_at = frameTarget;
            profiler.func_76319_b();
            try {
                mc.field_71460_t.func_78471_a(1.0f, System.nanoTime() + 4166666L);
            }
            catch (Exception e) {
                PlayerUtils.sendMessageToPlayer((EntityPlayer)player, (ITextComponent)Utils.localize(SCContent.frame, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:frame.error", new Object[0]), TextFormatting.RED, true);
                SecurityCraft.LOGGER.error("Frame feed at {} threw an exception while rendering the level. Deactivating clientside rendering for this feed", (Object)be.func_174877_v());
                e.printStackTrace();
                feed.markForRemoval();
            }
            frameTarget.func_147609_e();
            profiler.func_76320_a("securitycraft:apply_frame_frustum");
            Frustum frustum = FrameFeedHandler.prepareFrustum((Entity)securityCamera);
            if (be.shouldRotate() || !feed.hasVisibleSections() || feed.requiresFrustumUpdate()) {
                feed.updateVisibleSections(frustum);
            }
            profiler.func_76319_b();
        }
        securityCamera.func_70106_y();
        mc.func_175607_a(oldCamEntity);
        player.field_70726_aT = oldXRot;
        player.field_70727_aS = oldXRotO;
        player.field_71109_bG = oldYRot;
        player.field_71107_bF = oldYRotO;
        player.eyeHeight = oldEyeHeight;
        mc.field_71474_y.field_74320_O = oldCameraType;
        mc.field_71460_t.field_175073_D = oldRenderBlockOutline;
        mc.field_71438_f.field_72755_R.clear();
        mc.field_71438_f.field_72755_R.addAll(oldVisibleSections);
        mc.field_71460_t.field_175074_C = oldRenderHand;
        mc.field_71443_c = oldWidth;
        mc.field_71440_d = oldHeight;
        mc.field_147124_at = oldMainRenderTarget;
        mc.func_147110_a().func_147610_a(true);
        currentlyCapturedCamera = null;
        profiler.func_76319_b();
        profiler.func_76319_b();
        profiler.func_76320_a("render");
    }

    @SubscribeEvent
    public static void onClientTickPost(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && FrameFeedHandler.hasFeeds()) {
            FRAME_CAMERA_FEEDS.entrySet().removeIf(e -> ((CameraFeed)e.getValue()).shouldBeRemoved());
        }
    }

    public static Map<GlobalPos, CameraFeed> getFeedsToRender(double currentTime) {
        double feedsToRender = FRAME_CAMERA_FEEDS.size() + 1;
        double fpsCap = ConfigHandler.frameFeedFpsLimit;
        double frameInterval = 1.0 / fpsCap;
        double activeFramesPerMcFrame = MathHelper.func_76143_f((double)(fpsCap * feedsToRender / (double)Minecraft.func_175610_ah()));
        if (fpsCap < 260.0) {
            HashMap<GlobalPos, CameraFeed> activeFrameCameraFeeds = new HashMap<GlobalPos, CameraFeed>();
            for (Map.Entry<GlobalPos, CameraFeed> cameraView : FRAME_CAMERA_FEEDS.entrySet()) {
                double timeBetweenFrames = frameInterval / feedsToRender;
                double lastActiveTime = cameraView.getValue().lastActiveTime().get();
                if (currentTime < lastActiveTime + frameInterval || currentTime < lastFrameRendered + timeBetweenFrames) continue;
                double d = activeFramesPerMcFrame;
                activeFramesPerMcFrame = d - 1.0;
                if (d <= 0.0) continue;
                cameraView.getValue().lastActiveTime().set(currentTime);
                activeFrameCameraFeeds.put(cameraView.getKey(), cameraView.getValue());
            }
            return activeFrameCameraFeeds;
        }
        return FRAME_CAMERA_FEEDS;
    }

    public static void addFrameLink(FrameBlockEntity be, GlobalPos cameraPos) {
        CameraFeed feed = FRAME_CAMERA_FEEDS.computeIfAbsent(cameraPos, FrameFeedHandler::createFeedForCamera);
        feed.linkFrame(be);
    }

    public static void refreshCameraFeed(GlobalPos cameraPos) {
        FRAME_CAMERA_FEEDS.put(cameraPos, FrameFeedHandler.createFeedForCamera(cameraPos));
    }

    private static CameraFeed createFeedForCamera(GlobalPos cameraPos) {
        BlockPos pos = cameraPos.pos();
        RenderGlobal renderGlobal = Minecraft.func_71410_x().field_71438_f;
        renderGlobal.getClass();
        RenderGlobal.ContainerLocalRenderInformation startingSection = new RenderGlobal.ContainerLocalRenderInformation(renderGlobal, CameraViewAreaExtension.rawFetch(pos.func_177958_n() >> 4, MathHelper.func_76125_a((int)(pos.func_177956_o() >> 4), (int)0, (int)15), pos.func_177952_p() >> 4, true), null, 0);
        return new CameraFeed(cameraPos, startingSection);
    }

    public static void removeFrameLink(GlobalPos cameraPos, FrameBlockEntity be) {
        if (FRAME_CAMERA_FEEDS.containsKey(cameraPos)) {
            FRAME_CAMERA_FEEDS.get(cameraPos).unlinkFrame(be);
        }
    }

    public static void removeAllFrameLinks(GlobalPos cameraPos) {
        if (FRAME_CAMERA_FEEDS.containsKey(cameraPos)) {
            FRAME_CAMERA_FEEDS.remove(cameraPos);
        }
    }

    public static boolean isCapturingCamera() {
        return currentlyCapturedCamera != null;
    }

    public static boolean amIBeingCaptured(SecurityCameraBlockEntity be) {
        return FrameFeedHandler.isCapturingCamera() && currentlyCapturedCamera.pos().equals((Object)be.func_174877_v());
    }

    public static boolean hasFeeds() {
        return !FRAME_CAMERA_FEEDS.isEmpty();
    }

    public static boolean hasFeed(GlobalPos cameraPos) {
        return FRAME_CAMERA_FEEDS.containsKey(cameraPos);
    }

    public static CameraFeed getFeed(GlobalPos cameraPos) {
        return FRAME_CAMERA_FEEDS.get(cameraPos);
    }

    public static void removeAllFeeds() {
        FRAME_CAMERA_FEEDS.clear();
    }

    public static CameraFeed getCurrentlyCapturedFeed() {
        return FrameFeedHandler.getFeed(currentlyCapturedCamera);
    }

    public static int getFrameFeedViewDistance(FrameBlockEntity be) {
        int frameSpecificRenderDistance = be == null ? 32 : be.getChunkLoadingDistanceOption();
        return Math.min(frameSpecificRenderDistance, Math.min(ConfigHandler.frameFeedRenderDistance, Math.min(ConfigHandler.frameFeedViewDistance, Minecraft.func_71410_x().field_71474_y.field_151451_c)));
    }

    public static void updateLastUsedFrustum() {
        ClippingHelper currentClippingHelper = ClippingHelperImpl.func_78558_a();
        ClippingHelper newClippingHelper = new ClippingHelper();
        newClippingHelper.field_78557_a = (float[][])currentClippingHelper.field_78557_a.clone();
        newClippingHelper.field_178625_b = (float[])currentClippingHelper.field_178625_b.clone();
        newClippingHelper.field_178626_c = (float[])currentClippingHelper.field_178626_c.clone();
        newClippingHelper.field_78554_d = (float[])currentClippingHelper.field_78554_d.clone();
        lastUsedFrustum = new Frustum(newClippingHelper);
    }

    private static Frustum prepareFrustum(Entity entity) {
        if (lastUsedFrustum != null) {
            lastUsedFrustum.func_78547_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }
        return lastUsedFrustum;
    }

    static {
        lastFrameRendered = 0.0;
    }
}

