/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SecureRedstoneInterfaceBlock
extends DisguisableBlock {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyBool SENDER = PropertyBool.func_177716_a((String)"sender");
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private static final AxisAlignedBB[] SHAPES = new AxisAlignedBB[]{SecureRedstoneInterfaceBlock.makeShape(0.0, 9.0, 0.0, 16.0, 16.0, 16.0), SecureRedstoneInterfaceBlock.makeShape(0.0, 0.0, 0.0, 16.0, 7.0, 16.0), SecureRedstoneInterfaceBlock.makeShape(0.0, 0.0, 9.0, 16.0, 16.0, 16.0), SecureRedstoneInterfaceBlock.makeShape(0.0, 0.0, 0.0, 16.0, 16.0, 7.0), SecureRedstoneInterfaceBlock.makeShape(9.0, 0.0, 0.0, 16.0, 16.0, 16.0), SecureRedstoneInterfaceBlock.makeShape(0.0, 0.0, 0.0, 7.0, 16.0, 16.0)};

    private static AxisAlignedBB makeShape(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new AxisAlignedBB(x1 / 16.0, y1 / 16.0, z1 / 16.0, x2 / 16.0, y2 / 16.0, z2 / 16.0);
    }

    public SecureRedstoneInterfaceBlock(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SENDER, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        this.destroyTimeForOwner = 3.5f;
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return SHAPES[((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a()];
    }

    public boolean func_180639_a(World level, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        SecureRedstoneInterfaceBlockEntity be;
        TileEntity te = level.func_175625_s(pos);
        if (te instanceof SecureRedstoneInterfaceBlockEntity && (be = (SecureRedstoneInterfaceBlockEntity)te).isOwnedBy((Entity)player)) {
            if (!level.field_72995_K) {
                if (be.isDisabled()) {
                    player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else if (be.getOwner().isValidated()) {
                    SecurityCraft.network.sendTo((IMessage)new OpenScreen(OpenScreen.DataType.SECURE_REDSTONE_INTERFACE, pos), (EntityPlayerMP)player);
                } else {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize((Block)this, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.ownerInvalidated", new Object[0]), TextFormatting.RED);
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_149744_f(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)SENDER) == false;
    }

    public void func_189540_a(IBlockState state, World level, BlockPos pos, Block block, BlockPos fromPos) {
        SecureRedstoneInterfaceBlockEntity be;
        TileEntity te = level.func_175625_s(pos);
        if (te instanceof SecureRedstoneInterfaceBlockEntity && (be = (SecureRedstoneInterfaceBlockEntity)te).isSender() && !be.isDisabled()) {
            be.refreshPower();
        }
    }

    public int func_176211_b(IBlockState state, IBlockAccess level, BlockPos pos, EnumFacing direction) {
        if (state.func_177229_b((IProperty)FACING) == direction) {
            return this.func_180656_a(state, level, pos, direction);
        }
        return 0;
    }

    public int func_180656_a(IBlockState state, IBlockAccess level, BlockPos pos, EnumFacing side) {
        TileEntity te = level.func_175625_s(pos);
        if (te instanceof SecureRedstoneInterfaceBlockEntity) {
            return ((SecureRedstoneInterfaceBlockEntity)te).getRedstonePowerOutput();
        }
        return 0;
    }

    public void func_180663_b(World level, BlockPos pos, IBlockState state) {
        TileEntity te = level.func_175625_s(pos);
        if (te instanceof SecureRedstoneInterfaceBlockEntity) {
            SecureRedstoneInterfaceBlockEntity be = (SecureRedstoneInterfaceBlockEntity)te;
            be.disabled.setValue(true);
            if (be.isSender()) {
                be.tellSimilarReceiversToRefresh();
            } else {
                be.updateNeighbors();
            }
        }
        super.func_180663_b(level, pos, state);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing clickedFace, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)clickedFace);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + ((Boolean)state.func_177229_b((IProperty)SENDER) != false ? 6 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        boolean isSender = meta >= 6;
        return this.func_176223_P().func_177226_a((IProperty)SENDER, (Comparable)Boolean.valueOf(isSender)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)Math.min(isSender ? meta - 6 : meta, 6)));
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = super.func_176221_a(state, world, pos);
        if (actualState.func_177230_c() == this) {
            SecureRedstoneInterfaceBlockEntity be = (SecureRedstoneInterfaceBlockEntity)world.func_175625_s(pos);
            actualState = actualState.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(be.getPower() > 0));
        }
        return actualState;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new SecureRedstoneInterfaceBlockEntity();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SENDER, FACING, POWERED});
    }

    public static class DoorActivator
    implements Function<Object, IDoorActivator>,
    IDoorActivator {
        private final List<Block> blocks = Arrays.asList(SCContent.secureRedstoneInterface);

        @Override
        public IDoorActivator apply(Object o) {
            return this;
        }

        @Override
        public boolean isPowering(World level, BlockPos pos, IBlockState state, TileEntity be, EnumFacing direction, int distance) {
            return (Boolean)state.func_177229_b((IProperty)SENDER) == false && be instanceof SecureRedstoneInterfaceBlockEntity && ((SecureRedstoneInterfaceBlockEntity)be).isProtectedSignal() && ((SecureRedstoneInterfaceBlockEntity)be).getPower() > 0;
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }
    }
}

