/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LaserFieldBlock
extends OwnableBlock
implements IOverlayDisplay {
    public static final PropertyInteger BOUNDTYPE = PropertyInteger.func_177719_a((String)"boundtype", (int)1, (int)3);
    private static final AxisAlignedBB BOUNDTYPE_1_AABB;
    private static final AxisAlignedBB BOUNDTYPE_2_AABB;
    private static final AxisAlignedBB BOUNDTYPE_3_AABB;

    public LaserFieldBlock(Material material) {
        super(material);
        this.destroyTimeForOwner = -1.0f;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityLivingBase) {
            if (!state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos).func_72326_a(entity.func_174813_aQ())) {
                return;
            }
            for (int i = 0; i < ConfigHandler.laserBlockRange; ++i) {
                TileEntity te;
                BlockPos offsetPos = pos.func_177967_a(LaserFieldBlock.getFieldDirection(state), i);
                IBlockState offsetState = world.func_180495_p(offsetPos);
                Block block = offsetState.func_177230_c();
                if (block != SCContent.laserBlock || !((te = world.func_175625_s(offsetPos)) instanceof LaserBlockBlockEntity)) continue;
                LaserBlockBlockEntity laser = (LaserBlockBlockEntity)te;
                if (laser.isAllowed(entity) || laser.isConsideredInvisible((EntityLivingBase)entity)) {
                    return;
                }
                if (entity instanceof EntityPlayer && laser.isOwnedBy(entity) && laser.ignoresOwner()) break;
                if (laser.allowsOwnableEntity(entity)) {
                    return;
                }
                if (laser.isModuleEnabled(ModuleType.REDSTONE)) {
                    if (laser.timeSinceLastToggle() < 500L) {
                        laser.setLastToggleTime(System.currentTimeMillis());
                    } else {
                        int signalLength = laser.getSignalLength();
                        boolean wasPowered = (Boolean)offsetState.func_177229_b((IProperty)LaserBlock.POWERED);
                        laser.setLastToggleTime(System.currentTimeMillis());
                        world.func_175656_a(offsetPos, offsetState.func_177231_a((IProperty)LaserBlock.POWERED));
                        BlockUtils.updateIndirectNeighbors(world, offsetPos, SCContent.laserBlock);
                        laser.propagate(new ILinkedAction.StateChanged<Boolean>((IProperty<Boolean>)LaserBlock.POWERED, wasPowered, !wasPowered), laser);
                        if (signalLength > 0) {
                            world.func_175684_a(offsetPos, SCContent.laserBlock, signalLength);
                        }
                    }
                }
                if (!laser.isModuleEnabled(ModuleType.HARMING)) break;
                ((EntityLivingBase)entity).func_70097_a(CustomDamageSources.LASER, (float)ConfigHandler.laserDamage);
                break;
            }
        }
    }

    public static EnumFacing getFieldDirection(IBlockState state) {
        if (state.func_177230_c() instanceof LaserFieldBlock) {
            int boundType = (Integer)state.func_177229_b((IProperty)BOUNDTYPE);
            if (boundType == 1) {
                return EnumFacing.UP;
            }
            if (boundType == 2) {
                return EnumFacing.SOUTH;
            }
            if (boundType == 3) {
                return EnumFacing.EAST;
            }
        }
        return null;
    }

    public static int getBoundType(EnumFacing direction) {
        switch (direction) {
            case UP: 
            case DOWN: {
                return 1;
            }
            case NORTH: 
            case SOUTH: {
                return 2;
            }
            case EAST: 
            case WEST: {
                return 3;
            }
        }
        return 1;
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            int boundType = (Integer)state.func_177229_b((IProperty)BOUNDTYPE);
            EnumFacing direction = EnumFacing.func_82600_a((int)((boundType - 1) * 2));
            BlockUtils.removeInSequence((directionToCheck, stateToCheck) -> stateToCheck.func_177230_c() == this && (Integer)stateToCheck.func_177229_b((IProperty)BOUNDTYPE) == boundType, world, pos, direction, direction.func_176734_d());
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if ((Integer)source.func_180495_p(pos).func_177229_b((IProperty)BOUNDTYPE) == 1) {
            return BOUNDTYPE_1_AABB;
        }
        if ((Integer)source.func_180495_p(pos).func_177229_b((IProperty)BOUNDTYPE) == 2) {
            return BOUNDTYPE_2_AABB;
        }
        if ((Integer)source.func_180495_p(pos).func_177229_b((IProperty)BOUNDTYPE) == 3) {
            return BOUNDTYPE_3_AABB;
        }
        return field_185505_j;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BOUNDTYPE, (Comparable)Integer.valueOf(1));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BOUNDTYPE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BOUNDTYPE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BOUNDTYPE});
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        int boundType = (Integer)state.func_177229_b((IProperty)BOUNDTYPE);
        return rot == Rotation.CLOCKWISE_180 ? state : state.func_177226_a((IProperty)BOUNDTYPE, (Comparable)Integer.valueOf(boundType == 2 ? 3 : (boundType == 3 ? 2 : 1)));
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return null;
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return false;
    }

    static {
        float px = 0.0625f;
        BOUNDTYPE_1_AABB = new AxisAlignedBB(6.75 * (double)px, 0.0, 6.75 * (double)px, 9.25 * (double)px, 1.0, 9.25 * (double)px);
        BOUNDTYPE_2_AABB = new AxisAlignedBB(6.75 * (double)px, 6.75 * (double)px, 0.0, 9.25 * (double)px, 9.25 * (double)px, 1.0);
        BOUNDTYPE_3_AABB = new AxisAlignedBB(0.0, 6.75 * (double)px, 6.75 * (double)px, 1.0, 9.25 * (double)px, 9.25 * (double)px);
    }
}

