/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LaserBlock
extends DisguisableBlock {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public LaserBlock(Material material) {
        super(material);
        this.destroyTimeForOwner = 3.5f;
        this.setHarvestLevel("pickaxe", 0);
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        LaserBlockBlockEntity be = (LaserBlockBlockEntity)world.func_175625_s(pos);
        if (be.isOwnedBy((Entity)player)) {
            if (!world.field_72995_K) {
                if (!be.isEnabled()) {
                    player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else {
                    player.openGui((Object)SecurityCraft.instance, ScreenHandler.Screens.LASER_BLOCK.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        this.setLaser(world, pos, entity instanceof EntityPlayer ? (EntityPlayer)entity : null);
    }

    public void setLaser(World level, BlockPos pos, EntityPlayer player) {
        for (EnumFacing facing : EnumFacing.values()) {
            this.setLaser(level, pos, facing, player);
        }
    }

    public void setLaser(World world, BlockPos pos, EnumFacing facing, EntityPlayer player) {
        LaserBlockBlockEntity thisTe = (LaserBlockBlockEntity)world.func_175625_s(pos);
        if (!thisTe.isEnabled() || !thisTe.isSideEnabled(facing)) {
            return;
        }
        int boundType = LaserFieldBlock.getBoundType(facing);
        for (int i = 1; i <= ConfigHandler.laserBlockRange; ++i) {
            BlockPos offsetPos = pos.func_177967_a(facing, i);
            IBlockState offsetState = world.func_180495_p(offsetPos);
            Block offsetBlock = offsetState.func_177230_c();
            if (!offsetBlock.isAir(offsetState, (IBlockAccess)world, offsetPos) && !offsetBlock.func_176200_f((IBlockAccess)world, offsetPos) && offsetBlock != SCContent.laserBlock) {
                return;
            }
            if (offsetBlock != SCContent.laserBlock) continue;
            LaserBlockBlockEntity thatTe = (LaserBlockBlockEntity)world.func_175625_s(offsetPos);
            if (thisTe.getOwner().owns(thatTe) && thatTe.isEnabled()) {
                if (!thatTe.isSideEnabled(facing.func_176734_d())) {
                    thisTe.setSideEnabled(facing, false, null);
                    return;
                }
                ModuleType failedType = thisTe.synchronizeWith(thatTe);
                if (failedType != null) {
                    if (player != null) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize((Block)this, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:laser.sync_failed", Utils.getFormattedCoordinates(thatTe.func_174877_v()), Utils.localize(failedType.getTranslationKey(), new Object[0])), TextFormatting.RED);
                        thisTe.setSideEnabled(facing, false, null);
                        thatTe.setSideEnabled(facing.func_176734_d(), false, null);
                        player.func_71053_j();
                    }
                    return;
                }
                for (int j = 1; j < i; ++j) {
                    offsetPos = pos.func_177967_a(facing, j);
                    offsetState = world.func_180495_p(offsetPos);
                    if (!offsetState.func_177230_c().isAir(offsetState, (IBlockAccess)world, offsetPos) && !offsetState.func_177230_c().func_176200_f((IBlockAccess)world, offsetPos)) continue;
                    world.func_175656_a(offsetPos, SCContent.laserField.func_176223_P().func_177226_a((IProperty)LaserFieldBlock.BOUNDTYPE, (Comparable)Integer.valueOf(boundType)));
                    TileEntity te = world.func_175625_s(offsetPos);
                    if (!(te instanceof IOwnable)) continue;
                    ((IOwnable)te).setOwner(thisTe.getOwner().getUUID(), thisTe.getOwner().getName());
                }
                thatTe.getLensContainer().func_70296_d();
            }
            return;
        }
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            LaserBlock.destroyAdjacentLasers(world, pos);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof LaserBlockBlockEntity) {
            LaserBlockBlockEntity be = (LaserBlockBlockEntity)te;
            LensContainer lensContainer = be.getLensContainer();
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)lensContainer);
            lensContainer.func_174888_l();
            BlockUtils.updateIndirectNeighbors(world, pos, SCContent.laserBlock);
            LinkableBlockEntity.unlinkFromAllLinked(be);
        }
        super.func_180663_b(world, pos, state);
    }

    public static void destroyAdjacentLasers(World world, BlockPos pos) {
        BlockUtils.removeInSequence((direction, state) -> {
            if (state.func_177230_c() != SCContent.laserField) {
                return false;
            }
            return (Integer)state.func_177229_b((IProperty)LaserFieldBlock.BOUNDTYPE) == LaserFieldBlock.getBoundType(direction);
        }, world, pos, EnumFacing.field_82609_l);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.setLaser(world, pos, null);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te;
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && (te = world.func_175625_s(pos)) instanceof LaserBlockBlockEntity && ((LaserBlockBlockEntity)te).isModuleEnabled(ModuleType.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(state, world, pos, side);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(world, pos, SCContent.laserBlock);
        }
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            double x = (double)((float)pos.func_177958_n() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.func_177956_o() + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.func_177952_p() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            world.func_175688_a(EnumParticleTypes.REDSTONE, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return state.func_177230_c() != this ? 0 : ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new LaserBlockBlockEntity();
    }
}

