/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockEntityRenderDelegate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.AxisAlignedBB;

public class ProjectorBlockEntity
extends DisguisableBlockEntity
implements IInventory,
ILockable {
    public static final int MIN_WIDTH = 1;
    public static final int MAX_WIDTH = 10;
    public static final int MIN_RANGE = 1;
    public static final int MAX_RANGE = 30;
    public static final int MIN_OFFSET = -10;
    public static final int MAX_OFFSET = 10;
    public static final int RENDER_DISTANCE = 100;
    private int projectionWidth = 1;
    private int projectionHeight = 1;
    private int projectionRange = 5;
    private int projectionOffset = 0;
    private boolean activatedByRedstone = false;
    private boolean active = false;
    private boolean horizontal = false;
    private boolean overridingBlocks = false;
    private ItemStack projectedBlock = ItemStack.field_190927_a;
    private IBlockState projectedState = Blocks.field_150350_a.func_176223_P();

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g(100.0);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("width", this.projectionWidth);
        tag.func_74768_a("height", this.projectionHeight);
        tag.func_74768_a("range", this.projectionRange);
        tag.func_74768_a("offset", this.projectionOffset);
        tag.func_74757_a("active", this.active);
        tag.func_74757_a("horizontal", this.horizontal);
        tag.func_74757_a("overriding_blocks", this.overridingBlocks);
        tag.func_74782_a("storedItem", (NBTBase)this.projectedBlock.func_77955_b(new NBTTagCompound()));
        tag.func_74782_a("SavedState", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.projectedState));
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.projectionWidth = tag.func_74762_e("width");
        this.projectionHeight = tag.func_74762_e("height");
        this.projectionRange = tag.func_74762_e("range");
        this.projectionOffset = tag.func_74762_e("offset");
        this.activatedByRedstone = this.isModuleEnabled(ModuleType.REDSTONE);
        this.active = tag.func_74767_n("active");
        this.horizontal = tag.func_74767_n("horizontal");
        this.overridingBlocks = tag.func_74767_n("overriding_blocks");
        this.projectedBlock = new ItemStack(tag.func_74775_l("storedItem"));
        if (!tag.func_74764_b("SavedState")) {
            this.resetSavedState();
        } else {
            this.setProjectedState(NBTUtil.func_190008_d((NBTTagCompound)tag.func_74775_l("SavedState")));
        }
    }

    public int getProjectionWidth() {
        return this.projectionWidth;
    }

    public void setProjectionWidth(int width) {
        this.projectionWidth = width;
        this.func_70296_d();
    }

    public int getProjectionHeight() {
        return this.projectionHeight;
    }

    public void setProjectionHeight(int projectionHeight) {
        this.projectionHeight = projectionHeight;
        this.func_70296_d();
    }

    public int getProjectionRange() {
        return this.projectionRange;
    }

    public void setProjectionRange(int range) {
        this.projectionRange = range;
        this.func_70296_d();
    }

    public int getProjectionOffset() {
        return this.projectionOffset;
    }

    public void setProjectionOffset(int offset) {
        this.projectionOffset = offset;
        this.func_70296_d();
    }

    public boolean isActivatedByRedstone() {
        return this.activatedByRedstone;
    }

    public void setActivatedByRedstone(boolean redstone) {
        this.activatedByRedstone = redstone;
        this.func_70296_d();
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
        this.func_70296_d();
    }

    public boolean isOverridingBlocks() {
        return this.overridingBlocks;
    }

    public void setOverridingBlocks(boolean overridingBlocks) {
        this.overridingBlocks = overridingBlocks;
    }

    public boolean isActive() {
        return !this.activatedByRedstone || this.active;
    }

    public void setActive(boolean isOn) {
        this.active = isOn;
        this.func_70296_d();
    }

    public IBlockState getProjectedState() {
        return this.projectedState;
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.setActivatedByRedstone(true);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.setActivatedByRedstone(false);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[0];
    }

    public void func_174888_l() {
        this.projectedBlock = ItemStack.field_190927_a;
        this.resetSavedState();
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.projectedBlock;
        if (count >= 1) {
            this.projectedBlock = ItemStack.field_190927_a;
            this.resetSavedState();
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (slot == 36 ? this.projectedBlock : ItemStack.field_190927_a);
    }

    public boolean func_191420_l() {
        return this.projectedBlock.func_190926_b();
    }

    public boolean func_70300_a(EntityPlayer arg0) {
        return true;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.projectedBlock;
        this.projectedBlock = ItemStack.field_190927_a;
        this.resetSavedState();
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack = new ItemStack(stack.func_77973_b(), this.func_70297_j_());
        }
        ItemStack old = this.projectedBlock;
        this.projectedBlock = stack;
        if (old.func_77973_b() != this.projectedBlock.func_77973_b()) {
            this.resetSavedState();
        }
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlock;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b.field_72995_K) {
            BlockEntityRenderDelegate.PROJECTOR.putDelegateFor(this, this.projectedState, this.projectedBlock);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            BlockEntityRenderDelegate.PROJECTOR.removeDelegateOf(this);
        }
    }

    public void setProjectedState(IBlockState projectedState) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            if (this.projectedState.func_177230_c() != projectedState.func_177230_c()) {
                BlockEntityRenderDelegate.PROJECTOR.removeDelegateOf(this);
            }
            BlockEntityRenderDelegate.PROJECTOR.putDelegateFor(this, projectedState, this.projectedBlock);
        }
        this.projectedState = projectedState;
        this.func_70296_d();
    }

    public void resetSavedState() {
        if (this.projectedBlock.func_77973_b() instanceof ItemBlock) {
            this.setProjectedState(((ItemBlock)this.projectedBlock.func_77973_b()).func_179223_d().func_176203_a(this.projectedBlock.func_77960_j()));
        } else {
            this.projectedState = Blocks.field_150350_a.func_176223_P();
            if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
                BlockEntityRenderDelegate.PROJECTOR.removeDelegateOf(this);
            }
            this.func_70296_d();
        }
    }
}

