/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.DisplayCaseBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class DisplayCaseBlockEntity
extends CustomizableBlockEntity
implements ITickable,
IPasscodeProtected,
ILockable {
    private AxisAlignedBB renderBoundingBox = Block.field_185505_j;
    private Option.BooleanOption sendAllowlistMessage = new Option.SendAllowlistMessageOption(false);
    private Option.BooleanOption sendDenylistMessage = new Option.SendDenylistMessageOption(true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption(() -> ((DisplayCaseBlockEntity)this).func_174877_v());
    private long cooldownEnd = 0L;
    private ItemStack displayedStack = ItemStack.field_190927_a;
    private boolean hasReceivedData = false;
    private boolean shouldBeOpen;
    private float openness;
    private float oOpenness;
    private byte[] passcode;
    private UUID saltKey;
    private boolean saveSalt = false;
    private IBlockState state;

    public void func_174878_a(BlockPos pos) {
        super.func_174878_a(pos);
        this.renderBoundingBox = new AxisAlignedBB(pos);
    }

    public void func_73660_a() {
        this.oOpenness = this.openness;
        if (!this.shouldBeOpen && this.openness > 0.0f) {
            this.openness = Math.max(this.openness - 0.1f, 0.0f);
        } else if (this.shouldBeOpen && this.openness < 1.0f) {
            this.openness = Math.min(this.openness + 0.1f, 1.0f);
        }
    }

    @Override
    public void activate(EntityPlayer player) {
        Block block;
        if (!this.field_145850_b.field_72995_K && (block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()) instanceof DisplayCaseBlock) {
            ((DisplayCaseBlock)block).activate(this);
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(EntityPlayer player) {
        return !this.isOpen() && !this.getDisplayedStack().func_190926_b() && IPasscodeProtected.super.shouldAttemptCodebreak(player);
    }

    @Override
    public byte[] getPasscode() {
        return this.passcode == null || this.passcode.length == 0 ? null : this.passcode;
    }

    @Override
    public void setPasscode(byte[] passcode) {
        this.passcode = passcode;
        this.func_70296_d();
    }

    @Override
    public UUID getSaltKey() {
        return this.saltKey;
    }

    @Override
    public void setSaltKey(UUID saltKey) {
        this.saltKey = saltKey;
    }

    @Override
    public void setSaveSalt(boolean saveSalt) {
        this.saveSalt = saveSalt;
    }

    @Override
    public boolean shouldSaveSalt() {
        return this.saveSalt;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("DisplayedStack", (NBTBase)this.getDisplayedStack().func_77955_b(new NBTTagCompound()));
        tag.func_74757_a("ShouldBeOpen", this.shouldBeOpen);
        long cooldownLeft = this.getCooldownEnd() - System.currentTimeMillis();
        this.savePasscodeAndSalt(tag);
        tag.func_74772_a("cooldownLeft", cooldownLeft <= 0L ? -1L : cooldownLeft);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setDisplayedStack(new ItemStack(tag.func_74775_l("DisplayedStack")));
        this.shouldBeOpen = tag.func_74767_n("ShouldBeOpen");
        this.cooldownEnd = System.currentTimeMillis() + tag.func_74763_f("cooldownLeft");
        this.loadSaltKey(tag);
        this.loadPasscode(tag);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && !this.hasReceivedData) {
            this.forceOpen(this.shouldBeOpen);
            this.hasReceivedData = true;
        }
        if (tag.func_74764_b("sendMessage") && !tag.func_74767_n("sendMessage")) {
            this.sendAllowlistMessage.setValue(false);
            this.sendDenylistMessage.setValue(false);
        }
    }

    @Override
    public void startCooldown() {
        if (!this.isOnCooldown()) {
            this.cooldownEnd = System.currentTimeMillis() + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.getBlockState(), this.getBlockState(), 3);
            this.func_70296_d();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendAllowlistMessage, this.sendDenylistMessage, this.disabled, this.smartModuleCooldown};
    }

    public boolean sendsAllowlistMessage() {
        return (Boolean)this.sendAllowlistMessage.get();
    }

    public boolean sendsDenylistMessage() {
        return (Boolean)this.sendDenylistMessage.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public void setDisplayedStack(ItemStack displayedStack) {
        this.displayedStack = displayedStack;
        this.sync();
    }

    public ItemStack getDisplayedStack() {
        return this.displayedStack;
    }

    public void setOpen(boolean shouldBeOpen) {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, shouldBeOpen ? SCSounds.DISPLAY_CASE_OPEN.event : SCSounds.DISPLAY_CASE_CLOSE.event, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.shouldBeOpen = shouldBeOpen;
        this.sync();
    }

    public void forceOpen(boolean open) {
        this.shouldBeOpen = open;
        this.openness = open ? 1.0f : 0.0f;
        this.oOpenness = this.openness;
        this.sync();
    }

    public float getOpenness(float partialTicks) {
        return Utils.lerp(partialTicks, this.oOpenness, this.openness);
    }

    public boolean isOpen() {
        return this.shouldBeOpen;
    }

    @Override
    public void sync() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderBoundingBox;
    }

    public void setBlockState(IBlockState state) {
        this.state = state;
    }

    public IBlockState getBlockState() {
        if (this.state != null) {
            return this.state;
        }
        if (this.field_145850_b != null) {
            return this.field_145850_b.func_180495_p(this.field_174879_c);
        }
        return SCContent.displayCase.func_176223_P();
    }
}

