/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.geforcemods.securitycraft.api.IAttackTargetCheck;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SecurityCraftAPI {
    private static List<IExtractionBlock> registeredExtractionBlocks = new ArrayList<IExtractionBlock>();
    private static List<IPasscodeConvertible> registeredPasscodeConvertibles = new ArrayList<IPasscodeConvertible>();
    private static List<IAttackTargetCheck> registeredSentryAttackTargetChecks = new ArrayList<IAttackTargetCheck>();
    private static List<IDoorActivator> registeredDoorActivators = new ArrayList<IDoorActivator>();
    public static final String IMC_EXTRACTION_BLOCK_MSG = "registerExtractionBlock";
    public static final String IMC_PASSCODE_CONVERTIBLE_MSG = "registerPasscodeConvertible";
    public static final String IMC_SENTRY_ATTACK_TARGET_MSG = "registerSentryAttackTargetCheck";
    public static final String IMC_DOOR_ACTIVATOR_MSG = "registerDoorActivator";
    private static Logger logger = LogManager.getLogger(SecurityCraftAPI.class);

    private SecurityCraftAPI() {
    }

    public static void onIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            Optional value;
            if (msg.key.equals(IMC_EXTRACTION_BLOCK_MSG)) {
                value = msg.getFunctionValue(Object.class, IExtractionBlock.class);
                if (value.isPresent()) {
                    registeredExtractionBlocks.add((IExtractionBlock)((Function)value.get()).apply(null));
                    continue;
                }
                logger.error("Mod {} did not supply sufficient extraction block information.", (Object)msg.getSender());
                continue;
            }
            if (msg.key.equals(IMC_SENTRY_ATTACK_TARGET_MSG)) {
                value = msg.getFunctionValue(Object.class, IAttackTargetCheck.class);
                if (value.isPresent()) {
                    registeredSentryAttackTargetChecks.add((IAttackTargetCheck)((Function)value.get()).apply(null));
                    continue;
                }
                logger.error("Mod {} did not supply sufficient sufficient sentry attack target information.", (Object)msg.getSender());
                continue;
            }
            if (msg.key.equals(IMC_PASSCODE_CONVERTIBLE_MSG)) {
                value = msg.getFunctionValue(Object.class, IPasscodeConvertible.class);
                if (value.isPresent()) {
                    registeredPasscodeConvertibles.add((IPasscodeConvertible)((Function)value.get()).apply(null));
                    continue;
                }
                logger.error("Mod {} did not supply sufficient passcode convertible information.", (Object)msg.getSender());
                continue;
            }
            if (!msg.key.equals(IMC_DOOR_ACTIVATOR_MSG)) continue;
            value = msg.getFunctionValue(Object.class, IDoorActivator.class);
            if (value.isPresent()) {
                registeredDoorActivators.add((IDoorActivator)((Function)value.get()).apply(null));
                continue;
            }
            logger.error("Mod {} did not supply sufficient door activator information.", (Object)msg.getSender());
        }
        registeredExtractionBlocks = Collections.unmodifiableList(registeredExtractionBlocks);
        registeredPasscodeConvertibles = Collections.unmodifiableList(registeredPasscodeConvertibles);
        registeredSentryAttackTargetChecks = Collections.unmodifiableList(registeredSentryAttackTargetChecks);
        registeredDoorActivators = Collections.unmodifiableList(registeredDoorActivators);
    }

    public static List<IExtractionBlock> getRegisteredExtractionBlocks() {
        return registeredExtractionBlocks;
    }

    public static List<IAttackTargetCheck> getRegisteredSentryAttackTargetChecks() {
        return registeredSentryAttackTargetChecks;
    }

    public static List<IPasscodeConvertible> getRegisteredPasscodeConvertibles() {
        return registeredPasscodeConvertibles;
    }

    public static List<IDoorActivator> getRegisteredDoorActivators() {
        return registeredDoorActivators;
    }
}

