/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.CameraViewAreaExtension;
import net.geforcemods.securitycraft.items.TaserItem;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.CameraRedstoneModuleState;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.ClientProxy;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="securitycraft")
public class SCClientEventHandler {
    public static final ResourceLocation CAMERA_DASHBOARD = new ResourceLocation("securitycraft:textures/gui/camera/camera_dashboard.png");
    public static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    public static final ResourceLocation NIGHT_VISION = new ResourceLocation("minecraft:textures/gui/container/inventory.png");
    public static final ItemStack REDSTONE = new ItemStack(Items.field_151137_ax);
    private static final TextComponentTranslation REDSTONE_NOTE = Utils.localize("gui.securitycraft:camera.toggleRedstoneNote", new Object[0]);
    private static final TextComponentTranslation SMART_MODULE_NOTE = Utils.localize("gui.securitycraft:camera.smartModuleNote", new Object[0]);
    private static final CameraKeyInfoEntry[] CAMERA_KEY_INFO_LIST = new CameraKeyInfoEntry[]{new CameraKeyInfoEntry(() -> true, options -> Utils.localize("gui.securitycraft:camera.lookAround", options.field_74351_w.getDisplayName(), options.field_74370_x.getDisplayName(), options.field_74368_y.getDisplayName(), options.field_74366_z.getDisplayName()), $ -> true), new CameraKeyInfoEntry(() -> true, options -> Utils.localize("gui.securitycraft:camera.exit", options.field_74311_E.getDisplayName()), $ -> true), new CameraKeyInfoEntry(() -> true, $ -> Utils.localize("gui.securitycraft:camera.zoom", KeyBindings.cameraZoomIn.getDisplayName(), KeyBindings.cameraZoomOut.getDisplayName()), $ -> true), new CameraKeyInfoEntry(() -> ConfigHandler.allowCameraNightVision, $ -> Utils.localize("gui.securitycraft:camera.activateNightVision", KeyBindings.cameraActivateNightVision.getDisplayName()), $ -> true), new CameraKeyInfoEntry(() -> true, $ -> Utils.localize("gui.securitycraft:camera.toggleRedstone", KeyBindings.cameraEmitRedstone.getDisplayName()), be -> be.isModuleEnabled(ModuleType.REDSTONE)), new CameraKeyInfoEntry(() -> true, $ -> REDSTONE_NOTE, be -> be.isModuleEnabled(ModuleType.REDSTONE)), new CameraKeyInfoEntry(() -> true, $ -> Utils.localize("gui.securitycraft:camera.setDefaultViewingDirection", KeyBindings.setDefaultViewingDirection.getDisplayName()), be -> be.isModuleEnabled(ModuleType.SMART)), new CameraKeyInfoEntry(() -> true, $ -> SMART_MODULE_NOTE, be -> be.isModuleEnabled(ModuleType.SMART))};
    private static float cameraInfoMessageTime;

    private SCClientEventHandler() {
    }

    @SubscribeEvent
    public static void onClientTickPost(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && cameraInfoMessageTime >= 0.0f) {
            cameraInfoMessageTime -= 1.0f;
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        WorldClient level = mc.field_71441_e;
        float partialTicks = event.getPartialTicks();
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        for (BlockPos bcdPos : BlockEntityTracker.BLOCK_CHANGE_DETECTOR.getTrackedTileEntities((World)level)) {
            BlockChangeDetectorBlockEntity bcd;
            TileEntity be = level.func_175625_s(bcdPos);
            if (!(be instanceof BlockChangeDetectorBlockEntity) || !(bcd = (BlockChangeDetectorBlockEntity)be).isShowingHighlights() || !bcd.isOwnedBy((Entity)mc.field_71439_g)) continue;
            for (BlockChangeDetectorBlockEntity.ChangeEntry changeEntry : bcd.getFilteredEntries()) {
                BlockPos pos = changeEntry.pos;
                GlStateManager.func_179094_E();
                GlStateManager.func_179097_i();
                GlStateManager.func_179137_b((double)((double)pos.func_177958_n() - x), (double)((double)pos.func_177956_o() - y), (double)((double)pos.func_177952_p() - z));
                ClientUtils.renderBoxInLevel(0.0, 1.0, 0.0, 1.0, 1.0, bcd.getColor());
                GlStateManager.func_179126_j();
                GlStateManager.func_179121_F();
            }
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderSpecificHandEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)player)) {
            event.setCanceled(true);
        } else {
            boolean mainHandTaser = player.func_184614_ca().func_77973_b() instanceof TaserItem;
            boolean offhandTaser = player.func_184592_cb().func_77973_b() instanceof TaserItem;
            if (mainHandTaser || offhandTaser) {
                boolean isMainHand;
                boolean isRightHanded = mc.field_71474_y.field_186715_A == EnumHandSide.RIGHT;
                boolean bl = isMainHand = event.getHand() == EnumHand.MAIN_HAND;
                if (mainHandTaser && offhandTaser) {
                    event.setCanceled(!isMainHand);
                } else if (isMainHand && offhandTaser || !isMainHand && mainHandTaser) {
                    event.setCanceled(true);
                    return;
                }
                if (isRightHanded == isMainHand) {
                    GlStateManager.func_179109_b((float)-0.54f, (float)0.0f, (float)0.0f);
                } else {
                    GlStateManager.func_179109_b((float)0.58f, (float)0.0f, (float)0.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClickInput(MouseEvent event) {
        if (event.getButton() == 0 && ClientProxy.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            ChunkPos pos = event.getChunk().func_76632_l();
            CameraViewAreaExtension.onChunkUnload(pos.field_77276_a, pos.field_77275_b);
        }
    }

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if ((event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE || event.getType() == RenderGameOverlayEvent.ElementType.JUMPBAR || event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS) && ClientProxy.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && ClientProxy.isPlayerMountedOnCamera()) {
            Minecraft mc = Minecraft.func_71410_x();
            SCClientEventHandler.drawCameraOverlay(mc, (Gui)mc.field_71456_v, event.getResolution(), (EntityPlayer)mc.field_71439_g, (World)mc.field_71441_e, new BlockPos(mc.func_175606_aa().func_174791_d()), event.getPartialTicks());
        }
    }

    private static void drawCameraOverlay(Minecraft mc, Gui gui, ScaledResolution resolution, EntityPlayer player, World world, BlockPos pos, float partialTicks) {
        if (mc.field_71474_y.field_74330_P) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof SecurityCameraBlockEntity)) {
            return;
        }
        int scaledWidth = resolution.func_78326_a();
        int scaledHeight = resolution.func_78328_b();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        SecurityCameraBlockEntity te = (SecurityCameraBlockEntity)tile;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        IBlockState state = world.func_180495_p(pos);
        long worldTime = Minecraft.func_71410_x().field_71441_e.field_73011_w.getWorldTime();
        int hours24 = (int)((float)worldTime / 1000.0f + 6.0f) % 24;
        int hours = hours24 % 12;
        int minutes = (int)((float)worldTime / 16.666666f % 60.0f);
        String time = String.format("%02d:%02d %s", hours < 1 ? 12 : hours, minutes, hours24 < 12 ? "AM" : "PM");
        int timeY = 25;
        if (te.func_145818_k_()) {
            String cameraName = te.func_70005_c_();
            font.func_175063_a(cameraName, (float)(scaledWidth - font.func_78256_a(cameraName) - 8), 25.0f, 0xFFFFFF);
            timeY += 10;
        }
        font.func_175063_a(time, (float)(scaledWidth - font.func_78256_a(time) - 4), (float)timeY, 0xFFFFFF);
        if (cameraInfoMessageTime >= 0.0f) {
            float fadeOutPartialTick = Math.max(cameraInfoMessageTime + 1.0f - partialTicks, 1.0f);
            int alpha = (int)Math.ceil(255.0f * Math.min(20.0f, fadeOutPartialTick) / 20.0f);
            int heightOffset = 10;
            for (int i = CAMERA_KEY_INFO_LIST.length - 1; i >= 0; --i) {
                CameraKeyInfoEntry entry = CAMERA_KEY_INFO_LIST[i];
                if (!entry.enabled().get().booleanValue()) continue;
                entry.drawString(settings, font, scaledWidth, scaledHeight, heightOffset, te, alpha);
                heightOffset += 10;
            }
        }
        mc.func_110434_K().func_110577_a(CAMERA_DASHBOARD);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.func_73729_b(5, 0, 0, 0, 90, 20);
        gui.func_73729_b(scaledWidth - 70, 5, 190, 0, 65, 30);
        if (player.func_70660_b(Potion.func_180142_b((String)"night_vision")) == null) {
            gui.func_73729_b(28, 4, 90, 12, 16, 11);
        } else {
            mc.func_110434_K().func_110577_a(NIGHT_VISION);
            gui.func_73729_b(25, 2, 70, 218, 19, 16);
        }
        if (state.func_185911_a((IBlockAccess)world, pos, (EnumFacing)state.func_177229_b((IProperty)SecurityCameraBlock.FACING)) == 0) {
            if (!te.isModuleEnabled(ModuleType.REDSTONE)) {
                CameraRedstoneModuleState.NOT_INSTALLED.render(gui, 12, 2);
            } else {
                CameraRedstoneModuleState.DEACTIVATED.render(gui, 12, 2);
            }
        } else {
            CameraRedstoneModuleState.ACTIVATED.render(gui, 12, 2);
        }
    }

    public static void resetCameraInfoMessageTime() {
        cameraInfoMessageTime = 200.0f;
    }

    public static final class CameraKeyInfoEntry {
        private final Supplier<Boolean> enabled;
        private final Function<GameSettings, TextComponentTranslation> text;
        private final Predicate<SecurityCameraBlockEntity> whiteText;

        public CameraKeyInfoEntry(Supplier<Boolean> enabled, Function<GameSettings, TextComponentTranslation> text, Predicate<SecurityCameraBlockEntity> whiteText) {
            this.enabled = enabled;
            this.text = text;
            this.whiteText = whiteText;
        }

        public void drawString(GameSettings options, FontRenderer font, int scaledWidth, int scaledHeight, int heightOffset, SecurityCameraBlockEntity be, int alpha) {
            String formattedText = this.text().apply(options).func_150254_d();
            int textColor = this.whiteText().test(be) ? 0xFFFFFF : 0xFF3377;
            font.func_175063_a(formattedText, (float)(scaledWidth - font.func_78256_a(formattedText) - 8), (float)(scaledHeight - heightOffset), textColor + (alpha << 24));
        }

        public Supplier<Boolean> enabled() {
            return this.enabled;
        }

        public Function<GameSettings, TextComponentTranslation> text() {
            return this.text;
        }

        public Predicate<SecurityCameraBlockEntity> whiteText() {
            return this.whiteText;
        }
    }
}

