/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.ambientsounds;

import com.creativemd.ambientsounds.AmbientDimension;
import com.creativemd.ambientsounds.AmbientEnviroment;
import com.creativemd.ambientsounds.AmbientRegion;
import com.creativemd.ambientsounds.AmbientSound;
import com.creativemd.ambientsounds.AmbientSoundEngine;
import com.creativemd.ambientsounds.AmbientSounds;
import com.creativemd.ambientsounds.utils.Pair;
import com.creativemd.ambientsounds.utils.PairList;
import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.apache.commons.io.IOUtils;

public class AmbientEngine {
    public static final ResourceLocation engineLocation = new ResourceLocation("ambientsounds", "engine.json");
    private static final JsonParser parser = new JsonParser();
    private static final Gson gson = AmbientEngine.generateGson();
    protected transient PairList<String, AmbientRegion> allRegions = new PairList();
    protected transient PairList<String, AmbientRegion> generalRegions = new PairList();
    protected transient List<AmbientRegion> activeRegions = new ArrayList<AmbientRegion>();
    protected transient PairList<String, AmbientSound> sounds = new PairList();
    protected transient AmbientSoundEngine soundEngine;
    protected transient AmbientDimension silentDimension;
    protected transient List<String> silentDimensions = new ArrayList<String>();
    public AmbientDimension[] dimensions;
    public AmbientRegion[] regions;
    @SerializedName(value="enviroment-tick-time")
    public int enviromentTickTime = 40;
    @SerializedName(value="sound-tick-time")
    public int soundTickTime = 4;
    @SerializedName(value="block-scan-distance")
    public int blockScanDistance = 40;
    @SerializedName(value="outside-distance-min")
    public int outsideDistanceMin = 2;
    @SerializedName(value="outside-distance-max")
    public int outsideDistanceMax = 13;
    @SerializedName(value="average-height-scan-distance")
    public int averageHeightScanDistance = 2;
    @SerializedName(value="average-height-scan-count")
    public int averageHeightScanCount = 5;
    @SerializedName(value="biome-scan-distance")
    public int biomeScanDistance = 5;
    @SerializedName(value="biome-scan-count")
    public int biomeScanCount = 3;

    private static Gson generateGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ResourceLocation.class, (Object)new JsonDeserializer<ResourceLocation>(){

            public ResourceLocation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                    return new ResourceLocation(json.getAsString());
                }
                return null;
            }
        });
        return builder.create();
    }

    public static AmbientEngine loadAmbientEngine(AmbientSoundEngine soundEngine) {
        AmbientSounds.config.load();
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(engineLocation);
            JsonObject root = parser.parse(IOUtils.toString((InputStream)resource.func_110527_b(), (Charset)Charsets.UTF_8)).getAsJsonObject();
            AmbientEngine engine = (AmbientEngine)gson.fromJson((JsonElement)root, AmbientEngine.class);
            engine.init();
            AmbientSounds.logger.info("Successfully loaded sound engine. %s dimension(s) and %s region(s)", (Object)engine.dimensions.length, (Object)engine.allRegions.size());
            engine.soundEngine = soundEngine;
            return engine;
        }
        catch (Exception e) {
            e.printStackTrace();
            AmbientSounds.logger.error("Sound engine crashed, no sounds will be played!");
            AmbientSounds.config.save();
            return null;
        }
    }

    public AmbientRegion getRegion(String name) {
        return this.allRegions.getValue(name);
    }

    public AmbientEngine() {
        this.silentDimension = new AmbientDimension();
        this.silentDimension.name = "silent";
        this.silentDimension.volumeSetting = 0.0;
    }

    public AmbientDimension getDimension(World world) {
        String dimensionTypeName = world.field_73011_w.func_186058_p().func_186065_b();
        if (this.silentDimensions.contains(dimensionTypeName)) {
            return this.silentDimension;
        }
        for (int i = 0; i < this.dimensions.length; ++i) {
            if (!this.dimensions[i].is(world)) continue;
            return this.dimensions[i];
        }
        return this.silentDimension;
    }

    public void stopEngine() {
        if (!this.activeRegions.isEmpty()) {
            for (AmbientRegion region : this.activeRegions) {
                region.deactivate();
            }
            this.activeRegions.clear();
        }
    }

    private boolean checkRegion(AmbientDimension dimension, int i, AmbientRegion region) {
        if (region.name == null || region.name.isEmpty()) {
            if (dimension == null) {
                AmbientSounds.logger.error("Found invalid region at index={0}", (Object)i);
            } else {
                AmbientSounds.logger.error("Found invalid region in '{0}' at index={1}", (Object)dimension.name, (Object)i);
            }
            return false;
        }
        return true;
    }

    protected void addRegion(AmbientRegion region) {
        this.allRegions.add(region.name, region);
        region.volumeSetting = AmbientSounds.config.getFloat(region.name, "volume", 1.0f, 0.0f, 1.0f, "");
        String prefix = (region.dimension != null ? region.dimension.name + "." : "") + region.name + ".";
        if (region.sounds != null) {
            for (AmbientSound sound : region.sounds) {
                this.sounds.add(prefix + sound.name, sound);
                sound.fullName = prefix + sound.name;
                sound.volumeSetting = AmbientSounds.config.getFloat(sound.fullName, "volume", 1.0f, 0.0f, 1.0f, "");
            }
        }
    }

    public void init() {
        int i;
        AmbientSounds.config.load();
        for (i = 0; i < this.dimensions.length; ++i) {
            AmbientDimension dimension = this.dimensions[i];
            if (dimension.name == null || dimension.name.isEmpty()) {
                throw new RuntimeException("Invalid dimension name at index=" + i);
            }
            if (dimension.regions == null) continue;
            for (int j = 0; j < dimension.regions.length; ++j) {
                AmbientRegion region = dimension.regions[j];
                region.dimension = dimension;
                if (!this.checkRegion(dimension, j, region)) continue;
                this.addRegion(region);
            }
        }
        for (i = 0; i < this.regions.length; ++i) {
            AmbientRegion region = this.regions[i];
            if (!this.checkRegion(null, i, region)) continue;
            this.addRegion(region);
            this.generalRegions.add(region.name, region);
        }
        for (AmbientDimension dimension : this.dimensions) {
            dimension.init(this);
        }
        for (AmbientRegion region : this.allRegions.values()) {
            region.init(this);
        }
        AmbientSounds.config.save();
    }

    public void tick(AmbientEnviroment env) {
        if (env.dimension.regions != null) {
            for (AmbientRegion region : env.dimension.regions) {
                if (region.tick(env)) {
                    if (region.isActive()) continue;
                    region.activate();
                    this.activeRegions.add(region);
                    continue;
                }
                if (!region.isActive()) continue;
                region.deactivate();
                this.activeRegions.remove(region);
            }
        }
        for (AmbientRegion region : this.generalRegions.values()) {
            if (region.tick(env)) {
                if (region.isActive()) continue;
                region.activate();
                this.activeRegions.add(region);
                continue;
            }
            if (!region.isActive()) continue;
            region.deactivate();
            this.activeRegions.remove(region);
        }
    }

    public void fastTick(AmbientEnviroment env) {
        this.soundEngine.tick();
        if (!this.activeRegions.isEmpty()) {
            Iterator<AmbientRegion> iterator = this.activeRegions.iterator();
            while (iterator.hasNext()) {
                AmbientRegion region = iterator.next();
                if (region.fastTick(env)) continue;
                region.deactivate();
                iterator.remove();
            }
        }
    }

    public AmbientEnviroment.TerrainHeight calculateAverageHeight(World world, EntityPlayer player) {
        int sum = 0;
        int count = 0;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos center = new BlockPos((Entity)player);
        for (int x = -this.averageHeightScanCount; x <= this.averageHeightScanCount; ++x) {
            for (int z = -this.averageHeightScanCount; z <= this.averageHeightScanCount; ++z) {
                pos.func_181079_c(center.func_177958_n() + this.averageHeightScanDistance * x, center.func_177956_o(), center.func_177952_p() + this.averageHeightScanDistance * z);
                int height = AmbientEngine.getHeightBlock(world, pos);
                min = Math.min(height, min);
                max = Math.max(height, max);
                sum += height;
                ++count;
            }
        }
        return new AmbientEnviroment.TerrainHeight((double)sum / (double)count, min, max);
    }

    public PairList<AmbientEnviroment.BiomeArea, Float> calculateBiomes(World world, EntityPlayer player, double volume) {
        PairList<AmbientEnviroment.BiomeArea, Float> biomes = new PairList<AmbientEnviroment.BiomeArea, Float>();
        if (volume > 0.0) {
            int posX = (int)player.field_70165_t;
            int posZ = (int)player.field_70161_v;
            BlockPos center = new BlockPos(posX, 0, posZ);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = -this.biomeScanCount; x <= this.biomeScanCount; ++x) {
                for (int z = -this.biomeScanCount; z <= this.biomeScanCount; ++z) {
                    pos.func_181079_c(posX + x * this.biomeScanDistance, 0, posZ + z * this.biomeScanDistance);
                    Biome biome = world.func_180494_b((BlockPos)pos);
                    float biomeVolume = (float)((1.0 - Math.sqrt(center.func_177951_i((Vec3i)pos)) / (double)(this.biomeScanCount * this.biomeScanDistance * 2)) * volume);
                    AmbientEnviroment.BiomeArea area = new AmbientEnviroment.BiomeArea(biome, (BlockPos)pos);
                    if (biomes.containsKey(area)) {
                        biomes.set(area, Float.valueOf(Math.max(biomes.getValue(area).floatValue(), biomeVolume)));
                        continue;
                    }
                    biomes.add(area, Float.valueOf(biomeVolume));
                }
            }
            biomes.sort(new Comparator<Pair<AmbientEnviroment.BiomeArea, Float>>(){

                @Override
                public int compare(Pair<AmbientEnviroment.BiomeArea, Float> o1, Pair<AmbientEnviroment.BiomeArea, Float> o2) {
                    return ((Float)o1.value).compareTo((Float)o2.value);
                }
            });
        }
        return biomes;
    }

    public static int getHeightBlock(World world, BlockPos.MutableBlockPos pos) {
        int heighest = 2;
        for (int y = 45; y < 256; ++y) {
            pos.func_185336_p(y);
            IBlockState state = world.func_180495_p((BlockPos)pos);
            if ((!state.func_185914_p() || state.func_177230_c() instanceof BlockLeaves) && state.func_177230_c() != Blocks.field_150355_j) continue;
            heighest = y;
        }
        return heighest;
    }
}

