/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstoneflux.internal;

import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OldAPIChecker {
    private static final Logger LOGGER = LogManager.getLogger((String)"Redstone Flux");
    private static final Set<String> oldAPIClasses;

    public static void check() {
        boolean ignoreOldAPI = false;
        boolean crashOnOldAPI = true;
        if (!ignoreOldAPI) {
            HashSet<String> repackedAPIClasses = new HashSet<String>();
            for (String clazz : oldAPIClasses) {
                if (!OldAPIChecker.classExists(clazz)) continue;
                repackedAPIClasses.add(clazz);
            }
            if (!repackedAPIClasses.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                builder.append("\nRedstoneFlux has detected that the following OLD API classes from CoFHLib are being repacked!\n");
                for (String clazz : repackedAPIClasses) {
                    builder.append("    ").append(clazz);
                    builder.append(", loaded from: ").append(OldAPIChecker.getLoadPath(clazz));
                    builder.append("\n");
                }
                builder.append("\n");
                if (crashOnOldAPI) {
                    throw new RuntimeException(builder.toString());
                }
                LOGGER.fatal(builder.toString());
            }
        }
    }

    private static boolean classExists(String className) {
        try {
            Class.forName(className);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getLoadPath(String clazz) {
        String loadPath = "<unknown>";
        try {
            String name;
            URL resource;
            Class<?> c = Class.forName(clazz);
            ClassLoader loader = c.getClassLoader();
            if (loader == null) {
                for (loader = ClassLoader.getSystemClassLoader(); loader != null && loader.getParent() != null; loader = loader.getParent()) {
                }
            }
            if (loader != null && (resource = loader.getResource((name = c.getCanonicalName()).replace(".", "/") + ".class")) != null) {
                loadPath = resource.toString();
                int lastBang = loadPath.lastIndexOf("!");
                loadPath = loadPath.substring(0, lastBang);
                int lastSlash = loadPath.lastIndexOf("/");
                loadPath = loadPath.substring(lastSlash + 1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return loadPath;
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"cofh.api.energy.EnergyStorage");
        builder.add((Object)"cofh.api.energy.IEnergyConnection");
        builder.add((Object)"cofh.api.energy.IEnergyContainerItem");
        builder.add((Object)"cofh.api.energy.IEnergyHandler");
        builder.add((Object)"cofh.api.energy.IEnergyProvider");
        builder.add((Object)"cofh.api.energy.IEnergyReceiver");
        builder.add((Object)"cofh.api.energy.IEnergyStorage");
        builder.add((Object)"cofh.api.energy.IEnergyTransport");
        builder.add((Object)"cofh.api.energy.ItemEnergyContainer");
        builder.add((Object)"cofh.api.energy.TileEnergyHandler");
        oldAPIClasses = builder.build();
    }
}

