/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.world.gen.layer;

import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Arrays;
import net.minecraft.world.gen.layer.GenLayer;

public class GenLayerReplacement
extends GenLayer {
    private static final TIntIntMap biomeReplacements = new TIntIntHashMap();
    private static boolean mapChanged;
    private final GenLayer parent;
    private static int[] bakedMap;

    public GenLayerReplacement(GenLayer parent) {
        super(1L);
        this.parent = parent;
    }

    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        if (bakedMap == null || mapChanged) {
            GenLayerReplacement.bakeMap();
        }
        int[] ints = this.parent.func_75904_a(areaX, areaY, areaWidth, areaHeight);
        if (bakedMap.length == 0) {
            return ints;
        }
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] < 0 || ints[i] >= bakedMap.length || bakedMap[ints[i]] == -1) continue;
            ints[i] = bakedMap[ints[i]];
        }
        return ints;
    }

    private static void bakeMap() {
        int[] keys = biomeReplacements.keys();
        if (keys.length == 0) {
            bakedMap = new int[0];
        } else {
            Arrays.sort(keys);
            bakedMap = new int[keys[keys.length - 1] + 1];
            Arrays.fill(bakedMap, -1);
            for (int key : keys) {
                GenLayerReplacement.bakedMap[key] = biomeReplacements.get(key);
            }
        }
        mapChanged = false;
    }

    public static void registerReplacement(int toReplace, int replacement) {
        biomeReplacements.put(toReplace, replacement);
        mapChanged = true;
    }

    public static void setMapChanged(boolean mapChanged) {
        GenLayerReplacement.mapChanged = mapChanged;
    }

    static {
        bakedMap = null;
    }
}

