/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.handler;

import com.google.common.collect.Sets;
import java.util.Set;
import me.superckl.biometweaker.BiomeTweaker;
import me.superckl.biometweaker.common.world.WorldSavedDataASMTweaks;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldEventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldEvent.Load e) {
        WorldSavedDataASMTweaks data = WorldSavedDataASMTweaks.get(e.getWorld());
        if (data.isWasntSaved()) {
            data.func_76185_a();
            return;
        }
        Set<String> savedTweaks = data.getTweaks();
        Set<String> currentTweaks = BiomeTweaker.getInstance().getEnabledTweaks();
        if (savedTweaks.size() != currentTweaks.size() || Sets.intersection(savedTweaks, currentTweaks).size() != savedTweaks.size()) {
            boolean cont = StartupQuery.confirm((String)("WARNING\n\nBiomeTweaker has detected an inconsistency in enabled and saved tweaks.\n This could cause unpredicatable world generation and possibly corruption.\n Please ensure you did not change any BiomeTweakerCore configuration since\nlast loading this world. Proceed at your own risk.\n\nEnabled: " + currentTweaks.toString() + "\nSaved: " + savedTweaks.toString() + "\n\nContinue anyway?"));
            if (!cont) {
                FMLCommonHandler.instance().exitJava(1, false);
            } else {
                data.func_76185_a();
            }
        }
    }
}

