/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.superscript.script.command;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import me.superckl.api.superscript.script.command.ScriptCommandListing;
import me.superckl.api.superscript.script.command.ScriptCommandManager;
import me.superckl.api.superscript.script.object.ScriptObject;

public class ScriptCommandRegistry {
    public static final ScriptCommandRegistry INSTANCE = new ScriptCommandRegistry();
    private final Map<String, ScriptCommandManager> managers = new HashMap<String, ScriptCommandManager>();
    private final Map<Class<? extends ScriptObject>, Map<String, ScriptCommandListing>> commands = new HashMap<Class<? extends ScriptObject>, Map<String, ScriptCommandListing>>();

    public Map<Class<? extends ScriptObject>, Map<String, ScriptCommandListing>> getCommandsMap() {
        return new HashMap<Class<? extends ScriptObject>, Map<String, ScriptCommandListing>>(this.commands);
    }

    public void registerListing(String command, ScriptCommandListing listing, Class<? extends ScriptObject> clazz) {
        if (!this.commands.containsKey(clazz)) {
            this.commands.put(clazz, new LinkedHashMap());
        }
        this.commands.get(clazz).put(command, listing);
    }

    public void registerClassListing(Class<? extends ScriptObject> clazz, Map<String, ScriptCommandListing> listing) {
        this.commands.put(clazz, listing);
    }

    public Map<String, ScriptCommandListing> getListings(Class<? extends ScriptObject> clazz) {
        Map<String, ScriptCommandListing> listings = this.commands.get(clazz);
        if (listings == null) {
            listings = new LinkedHashMap<String, ScriptCommandListing>();
            this.commands.put(clazz, listings);
        }
        return new LinkedHashMap<String, ScriptCommandListing>(listings);
    }

    public ScriptCommandListing getListing(Class<? extends ScriptObject> clazz, String command) {
        ScriptCommandListing listing = this.getListings(clazz).get(command);
        if (listing == null) {
            listing = new ScriptCommandListing();
            this.commands.get(clazz).put(command, listing);
        }
        return listing;
    }

    public void registerScriptCommandManager(String key, ScriptCommandManager manager) {
        this.managers.put(key, manager);
    }

    public ScriptCommandManager getManagerFor(String owner) {
        return this.managers.get(owner);
    }
}

