/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.superscript.script.command;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.superckl.api.superscript.APIInfo;
import me.superckl.api.superscript.ApplicationStage;
import me.superckl.api.superscript.script.command.ScriptCommand;
import me.superckl.api.superscript.script.command.ScriptCommandManager;

public class BasicScriptCommandManager
extends ScriptCommandManager {
    private static ApplicationStage defaultStage = ApplicationStage.FINISHED_LOAD;
    private ApplicationStage currentStage = defaultStage;
    private final Map<ApplicationStage, List<ScriptCommand>> commands = Maps.newEnumMap(ApplicationStage.class);
    private final Set<ApplicationStage> appliedStages = EnumSet.noneOf(ApplicationStage.class);

    public boolean addCommand(ScriptCommand command) {
        return this.addCommand(command, this.getCurrentStage());
    }

    @Override
    public boolean addCommand(ScriptCommand command, ApplicationStage stage) {
        if (!this.commands.containsKey((Object)stage)) {
            this.commands.put(stage, new ArrayList());
        }
        if (this.appliedStages.contains((Object)stage) || command.performInst()) {
            try {
                command.perform();
            }
            catch (Exception e) {
                APIInfo.log.error("Failed to execute script command: " + command + ". Reason: " + e.getMessage());
                APIInfo.log.debug("Full stacktrace of error provided below for bug reports.", (Throwable)e);
            }
        }
        return command.performInst() ? true : this.commands.get((Object)stage).add(command);
    }

    @Override
    public void applyCommandsFor(ApplicationStage stage) {
        if (!this.commands.containsKey((Object)stage)) {
            return;
        }
        this.appliedStages.add(stage);
        List<ScriptCommand> commands = this.commands.get((Object)stage);
        APIInfo.log.info("Found " + commands.size() + " tweak" + (commands.size() > 1 ? "s" : "") + " to apply for stage " + stage.toString() + ". Applying...");
        for (ScriptCommand command : commands) {
            try {
                command.perform();
            }
            catch (Exception e) {
                APIInfo.log.error("Failed to execute script command: " + command + ". Reason: " + e.getMessage());
                APIInfo.log.debug("Full stacktrace of error provided below for bug reports.", (Throwable)e);
            }
        }
    }

    @Override
    public void reset() {
        this.commands.clear();
        this.currentStage = defaultStage;
    }

    public ApplicationStage getCurrentStage() {
        return this.currentStage;
    }

    public void setCurrentStage(ApplicationStage currentStage) {
        this.currentStage = currentStage;
    }

    public Map<ApplicationStage, List<ScriptCommand>> getCommands() {
        return this.commands;
    }

    public Set<ApplicationStage> getAppliedStages() {
        return this.appliedStages;
    }

    public static ApplicationStage getDefaultStage() {
        return defaultStage;
    }

    public static void setDefaultStage(ApplicationStage defaultStage) {
        BasicScriptCommandManager.defaultStage = defaultStage;
    }
}

