/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.biometweaker.event;

import com.google.gson.JsonPrimitive;
import me.superckl.api.biometweaker.block.BlockStateBuilder;
import me.superckl.api.superscript.script.command.ScriptCommand;
import me.superckl.biometweaker.common.world.gen.ReplacementConstraints;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class BiomeTweakEvent
extends Event {
    private final ScriptCommand command;
    private final Biome biome;

    public BiomeTweakEvent(ScriptCommand command, Biome biome) {
        this.command = command;
        this.biome = biome;
    }

    public ScriptCommand getCommand() {
        return this.command;
    }

    public Biome getBiome() {
        return this.biome;
    }

    @Cancelable
    public static class RegisterGenBlockReplacement
    extends BiomeTweakEvent {
        private final int weight;
        private final BlockStateBuilder<?> toReplace;
        private final ReplacementConstraints replaceWith;

        public RegisterGenBlockReplacement(ScriptCommand command, int weight, Biome biome, BlockStateBuilder<?> toReplace, ReplacementConstraints replaceWith2) {
            super(command, biome);
            this.weight = weight;
            this.toReplace = toReplace;
            this.replaceWith = replaceWith2;
        }

        public int getWeight() {
            return this.weight;
        }

        public BlockStateBuilder<?> getToReplace() {
            return this.toReplace;
        }

        public ReplacementConstraints getReplaceWith() {
            return this.replaceWith;
        }
    }

    @Cancelable
    public static class RemoveFlower
    extends BiomeTweakEvent {
        private final BlockStateBuilder<?> block;

        public RemoveFlower(ScriptCommand command, Biome biome, BlockStateBuilder<?> block) {
            super(command, biome);
            this.block = block;
        }

        public BlockStateBuilder<?> getBlock() {
            return this.block;
        }
    }

    @Cancelable
    public static class AddFlower
    extends BiomeTweakEvent {
        private final BlockStateBuilder<?> block;
        private final int weight;

        public AddFlower(ScriptCommand command, Biome biome, BlockStateBuilder<?> block, int weight) {
            super(command, biome);
            this.block = block;
            this.weight = weight;
        }

        public BlockStateBuilder<?> getBlock() {
            return this.block;
        }

        public int getWeight() {
            return this.weight;
        }
    }

    @Cancelable
    public static class SetProperty
    extends BiomeTweakEvent {
        private final String property;
        private final JsonPrimitive value;

        public SetProperty(ScriptCommand command, Biome biome, String property, JsonPrimitive value) {
            super(command, biome);
            this.property = property;
            this.value = value;
        }

        public String getProperty() {
            return this.property;
        }

        public JsonPrimitive getValue() {
            return this.value;
        }
    }

    @Cancelable
    public static class AddSpawn
    extends BiomeTweakEvent {
        private final Biome.SpawnListEntry spawnEntry;

        public AddSpawn(ScriptCommand command, Biome biome, Biome.SpawnListEntry spawnEntry) {
            super(command, biome);
            this.spawnEntry = spawnEntry;
        }

        public Biome.SpawnListEntry getSpawnEntry() {
            return this.spawnEntry;
        }
    }

    @Cancelable
    public static class RemoveAllSpawns
    extends BiomeTweakEvent {
        private final EnumCreatureType type;

        public RemoveAllSpawns(ScriptCommand command, Biome biome, EnumCreatureType type) {
            super(command, biome);
            this.type = type;
        }

        public EnumCreatureType getType() {
            return this.type;
        }
    }

    @Cancelable
    public static class RemoveSpawn
    extends BiomeTweakEvent {
        private final EnumCreatureType type;
        private final Class<?> entityClass;

        public RemoveSpawn(ScriptCommand command, Biome biome, EnumCreatureType type2, Class<?> entityClass) {
            super(command, biome);
            this.type = type2;
            this.entityClass = entityClass;
        }

        public EnumCreatureType getType() {
            return this.type;
        }

        public Class<?> getEntityClass() {
            return this.entityClass;
        }
    }

    @Cancelable
    public static class RemoveAllDictionaryTypes
    extends BiomeTweakEvent {
        public RemoveAllDictionaryTypes(ScriptCommand command, Biome biome) {
            super(command, biome);
        }
    }

    @Cancelable
    public static class RemoveDictionaryType
    extends BiomeTweakEvent {
        private final BiomeDictionary.Type type;

        public RemoveDictionaryType(ScriptCommand command, Biome biome, BiomeDictionary.Type type) {
            super(command, biome);
            this.type = type;
        }

        public BiomeDictionary.Type getType() {
            return this.type;
        }
    }

    @Cancelable
    public static class AddDictionaryType
    extends BiomeTweakEvent {
        private final BiomeDictionary.Type type;

        public AddDictionaryType(ScriptCommand command, Biome biome, BiomeDictionary.Type type) {
            super(command, biome);
            this.type = type;
        }

        public BiomeDictionary.Type getType() {
            return this.type;
        }
    }

    @Cancelable
    public static class RemoveOre
    extends BiomeTweakEvent {
        private final int biomeID;
        private final String type;

        public RemoveOre(ScriptCommand command, Biome biome, int biomeID, String type) {
            super(command, biome);
            this.biomeID = biomeID;
            this.type = type;
        }

        public int getBiomeID() {
            return this.biomeID;
        }

        public String getType() {
            return this.type;
        }
    }

    @Cancelable
    public static class RemoveFeature
    extends BiomeTweakEvent {
        private final int biomeID;
        private final String type;

        public RemoveFeature(ScriptCommand command, Biome biome, int biomeID, String type) {
            super(command, biome);
            this.biomeID = biomeID;
            this.type = type;
        }

        public int getBiomeID() {
            return this.biomeID;
        }

        public String getType() {
            return this.type;
        }
    }

    @Cancelable
    public static class RemoveDecoration
    extends BiomeTweakEvent {
        private final int biomeID;
        private final String type;

        public RemoveDecoration(ScriptCommand command, Biome biome, int biomeID, String type) {
            super(command, biome);
            this.biomeID = biomeID;
            this.type = type;
        }

        public int getBiomeID() {
            return this.biomeID;
        }

        public String getType() {
            return this.type;
        }
    }

    @Cancelable
    public static class Remove
    extends BiomeTweakEvent {
        private final BiomeManager.BiomeEntry entry;

        public Remove(ScriptCommand command, Biome biome, BiomeManager.BiomeEntry entry) {
            super(command, biome);
            this.entry = entry;
        }

        public BiomeManager.BiomeEntry getEntry() {
            return this.entry;
        }
    }

    @Cancelable
    public static class AddToGeneration
    extends BiomeTweakEvent {
        private final BiomeManager.BiomeEntry entry;

        public AddToGeneration(ScriptCommand command, Biome biome, BiomeManager.BiomeEntry entry) {
            super(command, biome);
            this.entry = entry;
        }

        public BiomeManager.BiomeEntry getEntry() {
            return this.entry;
        }
    }

    @Cancelable
    public static class Create
    extends BiomeTweakEvent {
        public Create(ScriptCommand command, Biome biome) {
            super(command, biome);
        }
    }
}

