/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.util;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkProviderServer;

public class LanderUtil {
    public static void makeSmallLandingSpot(World world, int x, int z, IBlockState block, boolean clearAbovePlatform) {
        LanderUtil.loadChunksAround(x, z, -1, (ChunkProviderServer)world.func_72863_F());
        LanderUtil.makePlatform(world, x, world.func_181545_F() - 1, z, block, clearAbovePlatform);
    }

    private static void loadChunksAround(int x, int z, int i, ChunkProviderServer cp) {
        cp.func_186028_c(x >> 4, z >> 4);
        if (x + i >> 4 != x >> 4) {
            cp.func_186028_c(x + i >> 4, z >> 4);
            if (z + i >> 4 != z >> 4) {
                cp.func_186028_c(x >> 4, z + i >> 4);
                cp.func_186028_c(x + i >> 4, z + i >> 4);
            }
        } else if (z + i >> 4 != z >> 4) {
            cp.func_186028_c(x >> 4, z + i >> 4);
        }
    }

    private static void makePlatform(World world, int x, int y, int z, IBlockState block, boolean clearAbovePlatform) {
        int zz;
        int xx;
        boolean isLiquidSpawn = world.func_180495_p(world.func_175672_r(new BlockPos(x, 255, z))).func_185904_a().func_76224_d();
        if (clearAbovePlatform) {
            if (!isLiquidSpawn) {
                y = world.func_175672_r(new BlockPos(x, 255, z)).func_177956_o() - 1;
            }
            for (xx = -5; xx < 5; ++xx) {
                for (zz = -5; zz < 5; ++zz) {
                    for (int yy = y; yy < 256; ++yy) {
                        if (xx == -5 && (zz == -5 || zz == 3) || xx == 3 && (zz == -5 || zz == 3)) continue;
                        LanderUtil.doBlock(world, x + xx, yy, z + zz, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
        if (isLiquidSpawn) {
            for (xx = -3; xx < 3; ++xx) {
                for (zz = -3; zz < 3; ++zz) {
                    if (xx == -3 && (zz == -3 || zz == 2) || xx == 2 && (zz == -3 || zz == 2)) continue;
                    LanderUtil.doBlock(world, x + xx, y, z + zz, block);
                }
            }
            for (xx = -2; xx < 2; ++xx) {
                for (zz = -2; zz < 2; ++zz) {
                    LanderUtil.doBlock(world, x + xx, y - 1, z + zz, block);
                }
            }
            LanderUtil.doBlock(world, x - 1, y - 2, z - 1, block);
            LanderUtil.doBlock(world, x - 1, y - 2, z, block);
            LanderUtil.doBlock(world, x, y - 2, z, block);
            LanderUtil.doBlock(world, x, y - 2, z - 1, block);
        }
    }

    private static void doBlock(World world, int x, int y, int z, IBlockState block) {
        world.func_180501_a(new BlockPos(x, y, z), block, 3);
    }
}

