/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Uranus.worldgen;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.extraplanets.world.features.WorldGenCustomIceSpike;
import com.mjr.extraplanets.world.features.WorldGenIgloo;
import com.mjr.mjrlegendslib.util.WorldGenUtilities;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.core.world.gen.WorldGenMinableMeta;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeDecoratorUranus
extends BiomeDecoratorSpace {
    private WorldGenerator iceGen = new WorldGenMinableMeta(Blocks.field_150432_aD, 18, 0, true, ExtraPlanets_Blocks.URANUS_BLOCKS, 2);
    private WorldGenerator crystalGen;
    private WorldGenerator denseIceGen;
    private WorldGenerator whiteGemGen;
    private World currentWorld;
    private int iceSpikesPerChunk = 5;
    private int LakesPerChunk = 5;
    private boolean isDecorating = false;

    public BiomeDecoratorUranus() {
        if (Config.GENERATE_ORES_URANUS) {
            this.crystalGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.URANUS_BLOCKS, 4, 3, true, ExtraPlanets_Blocks.URANUS_BLOCKS, 2);
            this.denseIceGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.DENSE_ICE, 8, 0, true, ExtraPlanets_Blocks.URANUS_BLOCKS, 0);
            this.whiteGemGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.URANUS_BLOCKS, 4, 7, true, ExtraPlanets_Blocks.URANUS_BLOCKS, 2);
        }
    }

    protected void setCurrentWorld(World world) {
        this.currentWorld = world;
    }

    protected World getCurrentWorld() {
        return this.currentWorld;
    }

    protected void decorate() {
        int i;
        if (this.isDecorating) {
            return;
        }
        this.isDecorating = true;
        this.generateOre(8, this.iceGen, 50, 120);
        if (Config.GENERATE_ORES_URANUS) {
            this.generateOre(20, this.crystalGen, 0, 32);
            this.generateOre(20, this.denseIceGen, 0, 256);
            this.generateOre(5, this.whiteGemGen, 0, 10);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.currentWorld, this.rand, new BlockPos(this.posX, 0, this.posZ)));
        for (i = 0; i < this.LakesPerChunk; ++i) {
            if (this.rand.nextInt(10) != 0) continue;
            WorldGenUtilities.generateLake((World)this.currentWorld, (Random)this.rand, (BlockPos)new BlockPos(this.posX, 0, this.posZ), (Block)ExtraPlanets_Fluids.FROZEN_WATER, (Block)ExtraPlanets_Blocks.URANUS_BLOCKS);
        }
        if (Config.GENERATE_URANUS_ICE_SPIKES) {
            for (i = 0; i < this.iceSpikesPerChunk; ++i) {
                if (this.rand.nextInt(20) != 0) continue;
                int x = this.posX + 6;
                int z = this.posZ + 6;
                int y = this.currentWorld.func_175672_r(new BlockPos(x, 0, z)).func_177956_o();
                new WorldGenCustomIceSpike().generate(this.currentWorld, this.rand, new BlockPos(x, y, z), ExtraPlanets_Blocks.URANUS_BLOCKS);
            }
        }
        if (Config.GENERATE_URANUS_IGLOOS && this.rand.nextInt(300) == 1) {
            WorldGenUtilities.generateStructure((WorldGenerator)new WorldGenIgloo(), (World)this.currentWorld, (Random)this.rand, (BlockPos)new BlockPos(this.posX, 0, this.posZ));
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.currentWorld, this.rand, new BlockPos(this.posX, 0, this.posZ)));
        this.isDecorating = false;
    }
}

