/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.blocks;

import java.util.Collection;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvanced;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCustomMulti
extends BlockAdvanced
implements IPartialSealableBlock,
ITileEntityProvider {
    public static final PropertyEnum<EnumBlockMultiType> MULTI_TYPE = PropertyEnum.func_177709_a((String)"type", EnumBlockMultiType.class);
    public static final PropertyInteger RENDER_TYPE = PropertyInteger.func_177719_a((String)"rendertype", (int)0, (int)7);
    protected static final AxisAlignedBB AABB_PAD = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);

    public BlockCustomMulti(String name) {
        super(GCBlocks.machine);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(name);
        this.func_149752_b(1.0E15f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumBlockMultiType)((Object)state.func_177229_b(MULTI_TYPE))) {
            case TIER_2_ROCKET_PAD: 
            case TIER_3_ROCKET_PAD: 
            case POWER_CHARGING_PAD: 
            case ROCKET_POWER_CHARGING_PAD: {
                return AABB_PAD;
            }
        }
        return field_185505_j;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMulti && (mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)pos)) {
            return world.func_180495_p(mainBlockPosition).func_185887_b(world, pos);
        }
        return this.field_149782_v;
    }

    public boolean isSealed(World world, BlockPos pos, EnumFacing direction) {
        int metadata = this.func_176201_c(world.func_180495_p(pos));
        if (metadata == 0 || metadata == 1) {
            return direction == EnumFacing.DOWN;
        }
        return false;
    }

    public void makeFakeBlock(World world, BlockPos pos, BlockPos mainBlock, int meta) {
        world.func_180501_a(pos, GCBlocks.fakeBlock.func_176203_a(meta), meta == 5 ? 3 : 0);
        world.func_175690_a(pos, (TileEntity)new TileEntityMulti(mainBlock));
    }

    public void makeFakeBlock(World worldObj, Collection<BlockPos> posList, BlockPos mainBlock, EnumBlockMultiType type) {
        for (BlockPos pos : posList) {
            worldObj.func_180501_a(pos, this.func_176223_P().func_177226_a(MULTI_TYPE, (Comparable)((Object)type)), 0);
            worldObj.func_175690_a(pos, (TileEntity)new TileEntityMulti(mainBlock));
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMulti) {
            ((TileEntityMulti)tileEntity).onBlockRemoval();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityMulti tileEntity = (TileEntityMulti)world.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        return tileEntity.onBlockActivated(world, pos, playerIn);
    }

    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityMulti tileEntity = (TileEntityMulti)world.func_175625_s(pos);
        return tileEntity.onBlockWrenched(world, pos, entityPlayer, hand, side, hitX, hitY, hitZ);
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        IBlockState mainBlockState;
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMulti && (mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)pos) && Blocks.field_150350_a != (mainBlockState = world.func_180495_p(mainBlockPosition)).func_177230_c()) {
            return mainBlockState.func_177230_c().getPickBlock(mainBlockState, target, world, mainBlockPosition, player);
        }
        return ItemStack.field_190927_a;
    }

    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(target.func_178782_a());
        if (tileEntity instanceof TileEntityMulti && (mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)target.func_178782_a())) {
            manager.addBlockHitEffects(mainBlockPosition, target);
        }
        return super.addHitEffects(state, world, target, manager);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(MULTI_TYPE, (Comparable)((Object)EnumBlockMultiType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBlockMultiType)((Object)state.func_177229_b(MULTI_TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MULTI_TYPE, RENDER_TYPE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)RENDER_TYPE, (Comparable)Integer.valueOf(0));
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static enum EnumBlockMultiType implements IStringSerializable
    {
        TIER_2_ROCKET_PAD(0, "tier2_rocket_pad"),
        TIER_3_ROCKET_PAD(1, "tier3_rocket_pad"),
        POWER_CHARGING_PAD(2, "powered_charging_pad"),
        ROCKET_POWER_CHARGING_PAD(3, "rocket_powered_charging_pad");

        private final int meta;
        private final String name;

        private EnumBlockMultiType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumBlockMultiType byMetadata(int meta) {
            return EnumBlockMultiType.values()[meta];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

