/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.entity;

import java.util.Set;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.api.event.BlockEntityEvent;
import me.ichun.mods.ichunutil.common.grab.GrabHandler;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.packet.mod.PacketRequestBlockEntityData;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class EntityBlock
extends Entity {
    private static final DataParameter<Float> ROT_YAW = EntityDataManager.func_187226_a(EntityBlock.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROT_PITCH = EntityDataManager.func_187226_a(EntityBlock.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> CAN_ROTATE = EntityDataManager.func_187226_a(EntityBlock.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BEHAVIOUR = EntityDataManager.func_187226_a(EntityBlock.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(EntityBlock.class, (DataSerializer)DataSerializers.field_187200_j);
    public EntityLivingBase creator;
    public float rotYaw;
    public float rotPitch;
    public float prevRotYaw;
    public float prevRotPitch;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;
    public int timeOnGround;
    public int timeExisting;
    public int timeout;
    public boolean canDropItems;
    public boolean requestedSetupPacket;
    public boolean setup;
    public IBlockState[][][] blocks;
    public NBTTagCompound[][][] tileEntityNBTs;
    public TileEntityMobSpawner[][][] mobSpawners;
    @SideOnly(value=Side.CLIENT)
    public TileEntity[][][] renderingTileEntities;
    public static float maxRotFac = 25.0f;

    public EntityBlock(World world) {
        super(world);
        this.func_70105_a(0.95f, 0.95f);
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.canDropItems = true;
        this.blocks = new IBlockState[][][]{{{Blocks.field_150350_a.func_176223_P()}}};
        this.tileEntityNBTs = new NBTTagCompound[1][1][1];
    }

    @Nullable
    public static EntityBlock createEntityBlock(World world, EntityLivingBase living, Set<BlockPos> poses) {
        return MinecraftForge.EVENT_BUS.post((Event)new BlockEntityEvent.Pickup(world, living, poses)) || poses.isEmpty() ? null : new EntityBlock(world, living, poses);
    }

    private EntityBlock(World world, EntityLivingBase living, Set<BlockPos> poses) {
        this(world);
        this.creator = living;
        int lowX = Integer.MAX_VALUE;
        int lowY = Integer.MAX_VALUE;
        int lowZ = Integer.MAX_VALUE;
        int highX = Integer.MIN_VALUE;
        int highY = Integer.MIN_VALUE;
        int highZ = Integer.MIN_VALUE;
        for (BlockPos pos : poses) {
            if (pos.func_177958_n() < lowX) {
                lowX = pos.func_177958_n();
            }
            if (pos.func_177956_o() < lowY) {
                lowY = pos.func_177956_o();
            }
            if (pos.func_177952_p() < lowZ) {
                lowZ = pos.func_177952_p();
            }
            if (pos.func_177958_n() > highX) {
                highX = pos.func_177958_n();
            }
            if (pos.func_177956_o() > highY) {
                highY = pos.func_177956_o();
            }
            if (pos.func_177952_p() <= highZ) continue;
            highZ = pos.func_177952_p();
        }
        int countX = highX - lowX + 1;
        int countY = highY - lowY + 1;
        int countZ = highZ - lowZ + 1;
        this.blocks = new IBlockState[countX][countY][countZ];
        this.tileEntityNBTs = new NBTTagCompound[countX][countY][countZ];
        this.mobSpawners = new TileEntityMobSpawner[countX][countY][countZ];
        world.restoringBlockSnapshots = true;
        for (BlockPos pos : poses) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() != Blocks.field_150350_a) {
                this.blocks[highX - pos.func_177958_n()][highY - pos.func_177956_o()][highZ - pos.func_177952_p()] = state;
                TileEntity te = world.func_175625_s(pos);
                if (te != null && state.func_177230_c().hasTileEntity(state)) {
                    world.func_175690_a(pos, state.func_177230_c().createTileEntity(world, state));
                    this.tileEntityNBTs[highX - pos.func_177958_n()][highY - pos.func_177956_o()][highZ - pos.func_177952_p()] = new NBTTagCompound();
                    te.func_189515_b(this.tileEntityNBTs[highX - pos.func_177958_n()][highY - pos.func_177956_o()][highZ - pos.func_177952_p()]);
                    te.func_145843_s();
                    TileEntity te1 = state.func_177230_c().createTileEntity(world, state);
                    if (te instanceof TileEntityMobSpawner && te1 instanceof TileEntityMobSpawner) {
                        te1.func_145839_a(this.tileEntityNBTs[highX - pos.func_177958_n()][highY - pos.func_177956_o()][highZ - pos.func_177952_p()]);
                        this.mobSpawners[highX - pos.func_177958_n()][highY - pos.func_177956_o()][highZ - pos.func_177952_p()] = (TileEntityMobSpawner)te1;
                    }
                }
            }
            world.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 2);
        }
        world.restoringBlockSnapshots = false;
        for (BlockPos pos : poses) {
            world.func_175698_g(pos);
        }
        this.setSize();
        this.func_70012_b((float)lowX + (float)countX / 2.0f, (double)lowY + 0.025, (float)lowZ + (float)countZ / 2.0f, 0.0f, 0.0f);
        this.func_184212_Q().func_187227_b(ORIGIN, (Object)new BlockPos(lowX, lowY, lowZ));
    }

    public void setSize() {
        this.func_70105_a((float)Math.max(this.blocks.length, this.blocks[0][0].length) - 0.05f, (float)this.blocks[0].length - 0.05f);
    }

    public void func_70105_a(float width, float height) {
        float f2 = this.field_70130_N;
        this.field_70130_N = width;
        this.field_70131_O = height;
        if (this.blocks == null) {
            this.func_174826_a(new AxisAlignedBB(this.func_174813_aQ().field_72340_a, this.func_174813_aQ().field_72338_b, this.func_174813_aQ().field_72339_c, this.func_174813_aQ().field_72340_a + (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + (double)this.field_70131_O, this.func_174813_aQ().field_72339_c + (double)this.field_70130_N));
        } else {
            this.func_174826_a(new AxisAlignedBB(this.func_174813_aQ().field_72340_a, this.func_174813_aQ().field_72338_b, this.func_174813_aQ().field_72339_c, this.func_174813_aQ().field_72340_a + (double)((float)this.blocks.length - 0.05f), this.func_174813_aQ().field_72338_b + (double)((float)this.blocks[0].length - 0.05f), this.func_174813_aQ().field_72339_c + (double)((float)this.blocks[0][0].length - 0.05f)));
        }
        if (this.field_70130_N > f2 && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
            this.func_70091_d(MoverType.SELF, f2 - this.field_70130_N, 0.0, f2 - this.field_70130_N);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 20.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityBlock.func_184183_bd()) * d0;
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        if (this.blocks == null) {
            float f = this.field_70130_N / 2.0f;
            float f1 = this.field_70131_O;
            this.func_174826_a(new AxisAlignedBB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
        } else {
            float fx = ((float)this.blocks.length - 0.05f) / 2.0f;
            float f1 = (float)this.blocks[0].length - 0.05f;
            float fz = ((float)this.blocks[0][0].length - 0.05f) / 2.0f;
            this.func_174826_a(new AxisAlignedBB(x - (double)fx, y, z - (double)fz, x + (double)fx, y + (double)f1, z + (double)fz));
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ROT_YAW, (Object)Float.valueOf(this.field_70146_Z.nextFloat() * (2.0f * maxRotFac) - maxRotFac));
        this.func_184212_Q().func_187214_a(ROT_PITCH, (Object)Float.valueOf(this.field_70146_Z.nextFloat() * (2.0f * maxRotFac) - maxRotFac));
        this.func_184212_Q().func_187214_a(CAN_ROTATE, (Object)true);
        this.func_184212_Q().func_187214_a(BEHAVIOUR, (Object)0);
        this.func_184212_Q().func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
    }

    public void setRotFacYaw(float f) {
        this.func_184212_Q().func_187227_b(ROT_YAW, (Object)Float.valueOf(f));
    }

    public float getRotFacYaw() {
        return ((Float)this.func_184212_Q().func_187225_a(ROT_YAW)).floatValue();
    }

    public void setRotFacPitch(float f) {
        this.func_184212_Q().func_187227_b(ROT_PITCH, (Object)Float.valueOf(f));
    }

    public float getRotFacPitch() {
        return ((Float)this.func_184212_Q().func_187225_a(ROT_PITCH)).floatValue();
    }

    public void setCanRotate(boolean flag) {
        this.func_184212_Q().func_187227_b(CAN_ROTATE, (Object)flag);
    }

    public boolean getCanRotate() {
        return (Boolean)this.func_184212_Q().func_187225_a(CAN_ROTATE);
    }

    public void setBehaviour(int i) {
        this.func_184212_Q().func_187227_b(BEHAVIOUR, (Object)1);
    }

    public int getBehaviour() {
        return (Integer)this.func_184212_Q().func_187225_a(BEHAVIOUR);
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.func_184212_Q().func_187225_a(ORIGIN);
    }

    public void func_70071_h_() {
        int j;
        if (this.field_70170_p.field_72995_K && !this.setup) {
            if (!this.requestedSetupPacket) {
                this.requestedSetupPacket = true;
                iChunUtil.channel.sendToServer(new PacketRequestBlockEntityData(this));
            }
            return;
        }
        ++this.timeExisting;
        if (!this.field_70170_p.field_72995_K && this.field_70163_u < -500.0) {
            this.func_70106_y();
            return;
        }
        this.field_70145_X = this.timeExisting < this.timeout;
        this.prevRotYaw = this.rotYaw;
        this.prevRotPitch = this.rotPitch;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!GrabHandler.isGrabbed(this, FMLCommonHandler.instance().getEffectiveSide())) {
            this.rotYaw += this.getRotFacYaw();
            this.rotPitch += this.getRotFacPitch();
        }
        this.prevMotionX = this.field_70159_w;
        this.prevMotionY = this.field_70181_x;
        this.prevMotionZ = this.field_70179_y;
        this.field_70181_x -= 0.06;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        boolean setBlock = false;
        if (!GrabHandler.isGrabbed(this, FMLCommonHandler.instance().getEffectiveSide())) {
            double bounceFactor;
            float blockHardness;
            double minBounceFactor;
            if (this.field_70122_E && this.field_70173_aa > 2) {
                ++this.timeOnGround;
                if (this.field_70181_x == 0.0) {
                    if (this.prevMotionY < -0.1) {
                        minBounceFactor = Math.sqrt(1.3333333333333333);
                        blockHardness = this.getAverageBlockHardness();
                        bounceFactor = (double)blockHardness < minBounceFactor ? minBounceFactor : (double)blockHardness;
                        this.field_70181_x = this.prevMotionY * -(1.0 / (2.0 * bounceFactor));
                        this.setRotFacYaw(this.field_70146_Z.nextFloat() * (2.0f * maxRotFac) - maxRotFac);
                        this.setRotFacPitch(this.field_70146_Z.nextFloat() * (2.0f * maxRotFac) - maxRotFac);
                    }
                    if (this.timeOnGround > 3) {
                        this.setRotFacYaw(this.getRotFacYaw() * 0.6f);
                        this.setRotFacPitch(this.getRotFacPitch() * 0.6f);
                    }
                    this.field_70159_w *= 0.7;
                    this.field_70179_y *= 0.7;
                    if (Math.abs(this.prevMotionX) < 0.05 && Math.abs(this.prevMotionZ) < 0.05 && Math.abs(this.prevMotionY) < 0.05 && (double)Math.abs(this.getRotFacYaw()) < 0.05 && (double)Math.abs(this.getRotFacPitch()) < 0.05) {
                        setBlock = true;
                    }
                }
            } else {
                this.timeOnGround = 0;
            }
            if (this.field_70159_w == 0.0 && this.prevMotionX != this.field_70159_w) {
                minBounceFactor = Math.sqrt(1.3333333333333333);
                blockHardness = this.getAverageBlockHardness();
                bounceFactor = 2.0 * ((double)blockHardness < minBounceFactor ? minBounceFactor : (double)blockHardness);
                this.field_70159_w = this.prevMotionX * -(1.0 / (bounceFactor * bounceFactor));
                this.setRotFacYaw(this.field_70146_Z.nextFloat() * (2.0f * maxRotFac) - maxRotFac);
                this.setRotFacPitch(this.field_70146_Z.nextFloat() * (2.0f * maxRotFac) - maxRotFac);
            }
            if (this.field_70179_y == 0.0 && this.prevMotionZ != this.field_70179_y) {
                minBounceFactor = Math.sqrt(1.3333333333333333);
                blockHardness = this.getAverageBlockHardness();
                bounceFactor = 2.0 * ((double)blockHardness < minBounceFactor ? minBounceFactor : (double)blockHardness);
                this.field_70179_y = this.prevMotionZ * -(1.0 / (bounceFactor * bounceFactor));
                this.setRotFacYaw(this.field_70146_Z.nextFloat() * (2.0f * maxRotFac) - maxRotFac);
                this.setRotFacPitch(this.field_70146_Z.nextFloat() * (2.0f * maxRotFac) - maxRotFac);
            }
        } else if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.mobSpawners.length; ++i) {
                for (j = this.mobSpawners[i].length - 1; j >= 0; --j) {
                    for (int k = 0; k < this.mobSpawners[i][j].length; ++k) {
                        if (this.mobSpawners[i][j][k] == null) continue;
                        BlockPos pos = new BlockPos(this.field_70165_t - (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a + 0.05) / 2.0 + (double)this.blocks.length - (double)i - 0.5, this.field_70163_u + (double)this.blocks[i].length - (double)j - 0.5, this.field_70161_v - (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c + 0.05) / 2.0 + (double)this.blocks[i][j].length - (double)k - 0.5);
                        TileEntityMobSpawner spawner = this.mobSpawners[i][j][k];
                        spawner.func_145834_a(this.field_70170_p);
                        spawner.func_174878_a(pos);
                        spawner.func_73660_a();
                        spawner.func_73660_a();
                    }
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && (setBlock || this.timeExisting > 6000)) {
            int i;
            this.func_70106_y();
            for (i = 0; i < this.blocks.length; ++i) {
                for (j = this.blocks[i].length - 1; j >= 0; --j) {
                    for (int k = 0; k < this.blocks[i][j].length; ++k) {
                        TileEntity te;
                        if (this.blocks[i][j][k] == null) continue;
                        BlockPos pos = new BlockPos(this.field_70165_t - (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a + 0.05) / 2.0 + (double)this.blocks.length - (double)i - 0.5, this.field_70163_u + (double)this.blocks[i].length - (double)j - 0.5, this.field_70161_v - (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c + 0.05) / 2.0 + (double)this.blocks[i][j].length - (double)k - 0.5);
                        if (MinecraftForge.EVENT_BUS.post((Event)new BlockEntityEvent.Place(this.field_70170_p, this, this.creator, this.blocks[i][j][k], pos)) || !this.field_70170_p.func_180501_a(pos, this.blocks[i][j][k], 2) && this.canDropItems) {
                            this.blocks[i][j][k].func_177230_c().func_176226_b(this.field_70170_p, pos, this.blocks[i][j][k], 0);
                            if (this.tileEntityNBTs[i][j][k] == null || !this.blocks[i][j][k].func_177230_c().hasTileEntity(this.blocks[i][j][k])) continue;
                            te = this.blocks[i][j][k].func_177230_c().createTileEntity(this.field_70170_p, this.blocks[i][j][k]);
                            if (te instanceof IInventory) {
                                te.func_145839_a(this.tileEntityNBTs[i][j][k]);
                                this.handleIInventoryBreak((IInventory)te);
                                continue;
                            }
                            if (!(te instanceof IItemHandler)) continue;
                            te.func_145839_a(this.tileEntityNBTs[i][j][k]);
                            this.handleIItemHandlerBreak((IItemHandler)te);
                            continue;
                        }
                        if (this.tileEntityNBTs[i][j][k] == null || !this.blocks[i][j][k].func_177230_c().hasTileEntity(this.blocks[i][j][k]) || (te = this.field_70170_p.func_175625_s(pos)) == null) continue;
                        NBTTagCompound nbttagcompound = new NBTTagCompound();
                        te.func_189515_b(nbttagcompound);
                        for (String s : this.tileEntityNBTs[i][j][k].func_150296_c()) {
                            NBTBase nbtbase = this.tileEntityNBTs[i][j][k].func_74781_a(s);
                            if (s.equals("x") || s.equals("y") || s.equals("z")) continue;
                            nbttagcompound.func_74782_a(s, nbtbase.func_74737_b());
                        }
                        te.func_145839_a(nbttagcompound);
                        te.func_70296_d();
                    }
                }
            }
            for (i = 0; i < this.blocks.length; ++i) {
                for (j = this.blocks[i].length - 1; j >= 0; --j) {
                    for (int k = 0; k < this.blocks[i][j].length; ++k) {
                        if (this.blocks[i][j][k] == null) continue;
                        BlockPos pos = new BlockPos(this.field_70165_t - (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a + 0.05) / 2.0 + (double)this.blocks.length - (double)i - 0.5, this.field_70163_u + (double)this.blocks[i].length - (double)j - 0.5, this.field_70161_v - (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c + 0.05) / 2.0 + (double)this.blocks[i][j].length - (double)k - 0.5);
                        this.field_70170_p.func_175722_b(pos, Blocks.field_150350_a, false);
                    }
                }
            }
        }
        this.field_70159_w *= 0.95;
        this.field_70181_x *= 0.95;
        this.field_70179_y *= 0.95;
    }

    public float getAverageBlockHardness() {
        float hardness = 0.0f;
        int count = 0;
        for (int i = 0; i < this.blocks.length; ++i) {
            for (int j = 0; j < this.blocks[i].length; ++j) {
                for (int k = 0; k < this.blocks[i][j].length; ++k) {
                    if (this.blocks[i][j][k] == null) continue;
                    hardness += this.blocks[i][j][k].func_177230_c().field_149782_v;
                    ++count;
                }
            }
        }
        return hardness / (float)count;
    }

    public void handleIItemHandlerBreak(IItemHandler var7) {
        if (var7 != null) {
            block0: for (int var8 = 0; var8 < var7.getSlots(); ++var8) {
                int tries = 0;
                while (tries < 200) {
                    ++tries;
                    ItemStack var9 = var7.extractItem(var8, Short.MAX_VALUE, false);
                    if (var9.func_190926_b() || var9.func_190916_E() <= 0) continue block0;
                    float var10 = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
                    float var11 = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
                    float var12 = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
                    EntityItem var14 = new EntityItem(this.field_70170_p, (double)((float)this.field_70165_t + var10), (double)((float)this.field_70163_u + var11), (double)((float)this.field_70161_v + var12), var9);
                    float var15 = 0.05f;
                    var14.field_70159_w = (float)this.field_70146_Z.nextGaussian() * var15;
                    var14.field_70181_x = (float)this.field_70146_Z.nextGaussian() * var15 + 0.2f;
                    var14.field_70179_y = (float)this.field_70146_Z.nextGaussian() * var15;
                    if (var9.func_77942_o()) {
                        var14.func_92059_d().func_77982_d(var9.func_77978_p().func_74737_b());
                    }
                    this.field_70170_p.func_72838_d((Entity)var14);
                }
            }
        }
    }

    public void handleIInventoryBreak(IInventory var7) {
        if (var7 != null) {
            for (int var8 = 0; var8 < var7.func_70302_i_(); ++var8) {
                ItemStack var9 = var7.func_70301_a(var8);
                if (var9.func_190926_b()) continue;
                float var10 = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
                float var11 = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
                float var12 = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
                while (var9.func_190916_E() > 0) {
                    int var13 = this.field_70146_Z.nextInt(21) + 10;
                    if (var13 > var9.func_190916_E()) {
                        var13 = var9.func_190916_E();
                    }
                    var9.func_190918_g(var13);
                    EntityItem var14 = new EntityItem(this.field_70170_p, (double)((float)this.field_70165_t + var10), (double)((float)this.field_70163_u + var11), (double)((float)this.field_70161_v + var12), new ItemStack(var9.func_77973_b(), var13, var9.func_77952_i()));
                    float var15 = 0.05f;
                    var14.field_70159_w = (float)this.field_70146_Z.nextGaussian() * var15;
                    var14.field_70181_x = (float)this.field_70146_Z.nextGaussian() * var15 + 0.2f;
                    var14.field_70179_y = (float)this.field_70146_Z.nextGaussian() * var15;
                    if (var9.func_77942_o()) {
                        var14.func_92059_d().func_77982_d(var9.func_77978_p().func_74737_b());
                    }
                    this.field_70170_p.func_72838_d((Entity)var14);
                }
            }
        }
    }

    public void shatter() {
        if (!(this.blocks.length == 1 && this.blocks[0].length == 1 && this.blocks[0][0].length == 1 || this.field_70128_L)) {
            this.func_70106_y();
            for (int i = 0; i < this.blocks.length; ++i) {
                for (int j = 0; j < this.blocks[i].length; ++j) {
                    for (int k = 0; k < this.blocks[i][j].length; ++k) {
                        if (this.blocks[i][j][k] == null) continue;
                        EntityBlock block = new EntityBlock(this.field_70170_p);
                        block.creator = this.creator;
                        block.blocks = new IBlockState[1][1][1];
                        block.tileEntityNBTs = new NBTTagCompound[1][1][1];
                        block.blocks[0][0][0] = this.blocks[i][j][k];
                        block.tileEntityNBTs[0][0][0] = this.tileEntityNBTs[i][j][k];
                        block.setSize();
                        block.func_70012_b(this.field_70165_t - (double)(this.field_70130_N / 2.0f) + (double)i, this.field_70163_u + (double)j, this.field_70161_v - (double)(this.field_70130_N / 2.0f) + (double)k, 0.0f, 0.0f);
                        block.setCanRotate(block.getCanRotate());
                        block.setBehaviour(block.getBehaviour());
                        float randMag = 0.1f;
                        block.field_70159_w = this.field_70159_w + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * randMag);
                        block.field_70181_x = this.field_70181_x + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * randMag);
                        block.field_70179_y = this.field_70179_y + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * randMag);
                        this.field_70170_p.func_72838_d((Entity)block);
                    }
                }
            }
        }
    }

    public boolean func_70067_L() {
        return this.timeExisting > this.timeout && !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return this.timeExisting > this.timeout && !this.field_70128_L;
    }

    protected void func_70081_e(int par1) {
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.func_174813_aQ();
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.timeExisting = tag.func_74762_e("timeExisting");
        this.setCanRotate(tag.func_74767_n("canRotate"));
        this.setBehaviour(tag.func_74762_e("behaviour"));
        if (tag.func_74762_e("lengthX") <= 0 || tag.func_74762_e("lengthY") <= 0 || tag.func_74762_e("lengthZ") <= 0) {
            this.blocks = new IBlockState[][][]{{{Blocks.field_150350_a.func_176223_P()}}};
            this.tileEntityNBTs = new NBTTagCompound[1][1][1];
        } else {
            this.blocks = new IBlockState[tag.func_74762_e("lengthX")][tag.func_74762_e("lengthY")][tag.func_74762_e("lengthZ")];
            this.tileEntityNBTs = new NBTTagCompound[tag.func_74762_e("lengthX")][tag.func_74762_e("lengthY")][tag.func_74762_e("lengthZ")];
        }
        for (int i = 0; i < this.blocks.length; ++i) {
            for (int j = 0; j < this.blocks[i].length; ++j) {
                for (int k = 0; k < this.blocks[i][j].length; ++k) {
                    if (!tag.func_74764_b("state_" + Integer.toString(i) + "_" + Integer.toString(j) + "_" + Integer.toString(k))) continue;
                    this.blocks[i][j][k] = Block.func_149684_b((String)tag.func_74779_i("state_" + Integer.toString(i) + "_" + Integer.toString(j) + "_" + Integer.toString(k))).func_176203_a(tag.func_74771_c("meta_" + Integer.toString(i) + "_" + Integer.toString(j) + "_" + Integer.toString(k)) & 0xFF);
                    if (this.blocks[i][j][k] == null || !tag.func_74764_b("tileEnt_" + Integer.toString(i) + "_" + Integer.toString(j) + "_" + Integer.toString(k))) continue;
                    this.tileEntityNBTs[i][j][k] = tag.func_74775_l("tileEnt_" + Integer.toString(i) + "_" + Integer.toString(j) + "_" + Integer.toString(k));
                }
            }
        }
        this.setSize();
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("timeExisting", this.timeExisting);
        tag.func_74757_a("canRotate", this.getCanRotate());
        tag.func_74768_a("behaviour", this.getBehaviour());
        tag.func_74768_a("lengthX", this.blocks.length);
        tag.func_74768_a("lengthY", this.blocks[0].length);
        tag.func_74768_a("lengthZ", this.blocks[0][0].length);
        for (int i = 0; i < this.blocks.length; ++i) {
            for (int j = 0; j < this.blocks[i].length; ++j) {
                for (int k = 0; k < this.blocks[i][j].length; ++k) {
                    if (this.blocks[i][j][k] == null) continue;
                    Block block = this.blocks[i][j][k].func_177230_c();
                    ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
                    tag.func_74778_a("state_" + Integer.toString(i) + "_" + Integer.toString(j) + "_" + Integer.toString(k), resourcelocation.toString());
                    tag.func_74774_a("meta_" + Integer.toString(i) + "_" + Integer.toString(j) + "_" + Integer.toString(k), (byte)block.func_176201_c(this.blocks[i][j][k]));
                    if (this.tileEntityNBTs[i][j][k] == null) continue;
                    tag.func_74782_a("tileEnt_" + Integer.toString(i) + "_" + Integer.toString(j) + "_" + Integer.toString(k), (NBTBase)this.tileEntityNBTs[i][j][k]);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }
}

