/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.power.rf;

import cofh.redstoneflux.api.IEnergyReceiver;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import omtteam.omlib.power.OMEnergyStorage;
import omtteam.omlib.tileentity.TileEntityElectric;

public class BaseRFReceiverWrapper
implements IEnergyReceiver {
    private final TileEntityElectric tile;
    private final EnumFacing facing;

    public BaseRFReceiverWrapper(TileEntityElectric tile, EnumFacing facing) {
        this.tile = tile;
        this.facing = facing;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        OMEnergyStorage storage = (OMEnergyStorage)this.tile.getCapability(CapabilityEnergy.ENERGY, this.facing);
        if (storage != null) {
            return storage.receiveEnergy(maxReceive, simulate);
        }
        return maxReceive;
    }

    public int getEnergyStored(EnumFacing from) {
        OMEnergyStorage storage = (OMEnergyStorage)this.tile.getCapability(CapabilityEnergy.ENERGY, this.facing);
        if (storage != null) {
            return storage.getEnergyStored();
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(EnumFacing from) {
        OMEnergyStorage storage = (OMEnergyStorage)this.tile.getCapability(CapabilityEnergy.ENERGY, this.facing);
        if (storage != null) {
            return storage.getMaxEnergyStored();
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }
}

