/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.tileentity;

import java.util.HashMap;
import li.cil.oc.api.machine.Arguments;
import mcjty.lib.api.power.IBigPower;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.network.ConnectionType;
import sonar.fluxnetworks.api.network.ITransferHandler;
import sonar.fluxnetworks.api.tiles.IFluxStorage;
import sonar.fluxnetworks.common.connection.transfer.FluxStorageHandler;
import sonar.fluxnetworks.common.data.FluxNetworkData;
import sonar.fluxnetworks.common.registry.RegistryBlocks;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

@Optional.Interface(iface="mcjty.lib.api.power.IBigPower", modid="theoneprobe")
public class TileFluxStorage
extends TileFluxCore
implements IFluxStorage,
IBigPower {
    private final FluxStorageHandler handler = new FluxStorageHandler(this);
    public static final int PRI_DIFF = 1000000;
    public static final int PRI_UPPER = -10000;
    private boolean needSyncEnergy = false;
    private final ItemStack stack;

    public TileFluxStorage() {
        this(new ItemStack(RegistryBlocks.FLUX_STORAGE_1));
        this.customName = "Basic Storage";
        this.limit = FluxConfig.basicTransfer;
    }

    private TileFluxStorage(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.STORAGE;
    }

    @Override
    public ITransferHandler getTransferHandler() {
        return this.handler;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.sendPacketIfNeeded();
        }
    }

    private void sendPacketIfNeeded() {
        if (this.needSyncEnergy && (this.field_145850_b.func_72820_D() & 3L) == 0L) {
            this.sendPackets();
            this.needSyncEnergy = false;
        }
    }

    public void markServerEnergyChanged() {
        this.needSyncEnergy = true;
    }

    @Override
    public int getLogicPriority() {
        return this.surgeMode ? -10000 : Math.min(this.priority - 1000000, -10000);
    }

    @Override
    public long getMaxTransferLimit() {
        return FluxConfig.basicCapacity;
    }

    public ItemStack writeStorageToDisplayStack(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound subTag = new NBTTagCompound();
        subTag.func_74772_a("energy", this.getTransferBuffer());
        subTag.func_74768_a(FluxNetworkData.NETWORK_ID, this.networkID);
        tag.func_74782_a("FluxData", (NBTBase)subTag);
        tag.func_74757_a("GuiColor", true);
        stack.func_77982_d(tag);
        return stack;
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.writeStorageToDisplayStack(this.stack);
    }

    @Optional.Method(modid="theoneprobe")
    public long getStoredPower() {
        return this.getTransferBuffer();
    }

    @Optional.Method(modid="theoneprobe")
    public long getCapacity() {
        return this.getMaxTransferLimit();
    }

    @Override
    public String getPeripheralName() {
        return "flux_storage";
    }

    @Override
    public Object[] invokeMethods(String method, Arguments arguments) {
        if (method.equals("getFluxInfo")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("customName", this.customName);
            map.put("priority", this.priority);
            map.put("transferLimit", this.limit);
            map.put("surgeMode", this.surgeMode);
            map.put("unlimited", this.disableLimit);
            map.put("energyStored", this.getTransferBuffer());
            map.put("maxStorage", this.getMaxTransferLimit());
            return new Object[]{map};
        }
        return super.invokeMethods(method, arguments);
    }

    public static class Gargantuan
    extends TileFluxStorage {
        public Gargantuan() {
            super(new ItemStack(RegistryBlocks.FLUX_STORAGE_3));
            this.customName = "Gargantuan Storage";
            this.limit = FluxConfig.gargantuanTransfer;
        }

        @Override
        public long getMaxTransferLimit() {
            return FluxConfig.gargantuanCapacity;
        }
    }

    public static class Herculean
    extends TileFluxStorage {
        public Herculean() {
            super(new ItemStack(RegistryBlocks.FLUX_STORAGE_2));
            this.customName = "Herculean Storage";
            this.limit = FluxConfig.herculeanTransfer;
        }

        @Override
        public long getMaxTransferLimit() {
            return FluxConfig.herculeanCapacity;
        }
    }
}

