/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.fluxnetworks.api.network.FluxLogicType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.utils.Coord4D;
import sonar.fluxnetworks.common.connection.FluxLiteConnector;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.network.PacketConnectionUpdate;

public class PacketConnectionUpdateRequest
implements IMessageHandler<ConnectionRequestMessage, IMessage> {
    public IMessage onMessage(ConnectionRequestMessage message, MessageContext ctx) {
        if (message.coords.isEmpty()) {
            return null;
        }
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(message.networkID);
        if (!network.isInvalid()) {
            ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
            List onlineConnectors = network.getConnections(FluxLogicType.ANY);
            message.coords.forEach(c -> onlineConnectors.stream().filter(f -> f.getCoords().equals(c)).findFirst().ifPresent(f -> tags.add(FluxLiteConnector.writeCustomNBT(f, new NBTTagCompound()))));
            return new PacketConnectionUpdate.NetworkConnectionMessage(message.networkID, tags);
        }
        return null;
    }

    public static class ConnectionRequestMessage
    implements IMessage {
        public int networkID;
        public List<Coord4D> coords = new ArrayList<Coord4D>();

        public ConnectionRequestMessage() {
        }

        public ConnectionRequestMessage(int networkID, List<Coord4D> coords) {
            this.networkID = networkID;
            this.coords = coords;
        }

        public void fromBytes(ByteBuf buf) {
            this.networkID = buf.readInt();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.coords.add(new Coord4D(buf));
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.networkID);
            buf.writeInt(this.coords.size());
            this.coords.forEach(c -> c.write(buf));
        }
    }
}

