/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import sonar.fluxnetworks.api.translate.ITranslationProvider;
import sonar.fluxnetworks.api.translate.Translation;

public class LocalizationHandler
implements ISelectiveResourceReloadListener {
    public List<ITranslationProvider> providers = new ArrayList<ITranslationProvider>();

    public void clear() {
        this.providers.clear();
    }

    public void add(ITranslationProvider handler) {
        this.providers.add(handler);
        this.loadHandler(handler);
    }

    public void remove(ITranslationProvider handler) {
        this.providers.remove(handler);
    }

    public void loadHandler(ITranslationProvider handler) {
        handler.getTranslations(new ArrayList<Translation>()).forEach(LocalizationHandler::translate);
    }

    public static Translation translate(Translation l) {
        l.translated = LocalizationHandler.translate(l.key);
        return l;
    }

    public static String translate(String string) {
        return new TextComponentTranslation(string, new Object[0]).func_150254_d();
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        this.providers.forEach(this::loadHandler);
    }
}

