/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.common.data.FluxNetworkData;

public class FluxChunkManager {
    public static final Map<Integer, ForgeChunkManager.Ticket> worldTickets = new HashMap<Integer, ForgeChunkManager.Ticket>();

    public static void clear() {
        worldTickets.clear();
    }

    public static boolean forceChunk(World world, ChunkPos chunk) {
        if (FluxNetworkData.get().loadedChunks.computeIfAbsent(world.field_73011_w.getDimension(), l -> new ArrayList()).contains(chunk)) {
            return false;
        }
        ForgeChunkManager.Ticket ticket = worldTickets.computeIfAbsent(world.field_73011_w.getDimension(), t -> ForgeChunkManager.requestTicket((Object)FluxNetworks.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL));
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunk);
        FluxNetworkData.get().loadedChunks.get(world.field_73011_w.getDimension()).add(chunk);
        return true;
    }

    public static void releaseChunk(World world, ChunkPos chunk) {
        ForgeChunkManager.Ticket ticket = worldTickets.get(world.field_73011_w.getDimension());
        if (ticket == null) {
            return;
        }
        long count = ((List)FluxNetworkData.get().loadedChunks.getOrDefault(world.field_73011_w.getDimension(), new ArrayList())).stream().filter(chunkPos -> chunkPos.equals((Object)chunk)).count();
        if (count > 0L) {
            FluxNetworkData.get().loadedChunks.get(world.field_73011_w.getDimension()).remove(chunk);
            if (count <= 1L) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunk);
            }
        }
        if (ticket.getChunkList().isEmpty()) {
            worldTickets.remove(ticket.world.field_73011_w.getDimension());
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }

    public static void callback(List<ForgeChunkManager.Ticket> tickets, World world) {
        int dim = world.field_73011_w.getDimension();
        ForgeChunkManager.Ticket ticket = tickets.get(0);
        worldTickets.putIfAbsent(dim, ticket);
        if (FluxConfig.enableChunkLoading) {
            for (ChunkPos pos : (List)FluxNetworkData.get().loadedChunks.getOrDefault(dim, new ArrayList())) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos);
            }
        }
    }
}

