/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.FluxLogicType;
import sonar.fluxnetworks.api.network.ISuperAdmin;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.SecurityType;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.tiles.IFluxPlug;
import sonar.fluxnetworks.api.tiles.IFluxPoint;
import sonar.fluxnetworks.api.utils.Capabilities;
import sonar.fluxnetworks.api.utils.EnergyType;
import sonar.fluxnetworks.common.connection.FluxLiteConnector;
import sonar.fluxnetworks.common.connection.FluxNetworkBase;
import sonar.fluxnetworks.common.connection.NetworkStatistics;
import sonar.fluxnetworks.common.connection.PriorityGroup;
import sonar.fluxnetworks.common.connection.TransferIterator;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.event.FluxConnectionEvent;

public class FluxNetworkServer
extends FluxNetworkBase {
    private final Map<FluxLogicType, List<? extends IFluxConnector>> connections = new EnumMap<FluxLogicType, List<? extends IFluxConnector>>(FluxLogicType.class);
    private final Queue<IFluxConnector> toAdd = new LinkedList<IFluxConnector>();
    private final Queue<IFluxConnector> toRemove = new LinkedList<IFluxConnector>();
    public boolean sortConnections = true;
    private final List<PriorityGroup<IFluxPlug>> sortedPlugs = new ArrayList<PriorityGroup<IFluxPlug>>();
    private final List<PriorityGroup<IFluxPoint>> sortedPoints = new ArrayList<PriorityGroup<IFluxPoint>>();
    private final TransferIterator<IFluxPlug> plugTransferIterator = new TransferIterator(false);
    private final TransferIterator<IFluxPoint> pointTransferIterator = new TransferIterator(true);
    public long bufferLimiter = 0L;

    public FluxNetworkServer() {
    }

    public FluxNetworkServer(int id, String name, SecurityType security, int color, UUID owner, EnergyType energy, String password) {
        super(id, name, security, color, owner, energy, password);
    }

    private void handleConnectionQueue() {
        IFluxConnector device;
        while ((device = this.toAdd.poll()) != null) {
            for (FluxLogicType type : FluxLogicType.getValidTypes(device)) {
                this.sortConnections |= FluxUtils.addWithCheck(this.getConnections(type), device);
            }
            MinecraftForge.EVENT_BUS.post((Event)new FluxConnectionEvent.Connected(device, this));
        }
        while ((device = this.toRemove.poll()) != null) {
            for (FluxLogicType type : FluxLogicType.getValidTypes(device)) {
                this.sortConnections |= this.getConnections(type).remove(device);
            }
        }
        if (this.sortConnections) {
            this.sortConnections();
            this.sortConnections = false;
        }
    }

    @Override
    @Nonnull
    public <T extends IFluxConnector> List<T> getConnections(FluxLogicType type) {
        return this.connections.computeIfAbsent(type, m -> new ArrayList());
    }

    @Override
    public void onEndServerTick() {
        ((NetworkStatistics)this.network_stats.getValue()).startProfiling();
        this.handleConnectionQueue();
        this.bufferLimiter = 0L;
        List devices = this.getConnections(FluxLogicType.ANY);
        for (IFluxConnector f : devices) {
            f.getTransferHandler().onCycleStart();
        }
        if (!this.sortedPoints.isEmpty() && !this.sortedPlugs.isEmpty()) {
            this.plugTransferIterator.reset(this.sortedPlugs);
            this.pointTransferIterator.reset(this.sortedPoints);
            block1: while (this.pointTransferIterator.hasNext()) {
                while (this.plugTransferIterator.hasNext()) {
                    IFluxPlug plug = (IFluxPlug)this.plugTransferIterator.next();
                    IFluxPoint point = (IFluxPoint)this.pointTransferIterator.next();
                    if (plug.getConnectionType() == point.getConnectionType()) break block1;
                    long operate = plug.getTransferHandler().removeFromBuffer(point.getTransferHandler().getRequest());
                    if (operate > 0L) {
                        point.getTransferHandler().addToBuffer(operate);
                        continue block1;
                    }
                    this.plugTransferIterator.incrementFlux();
                }
                break block1;
            }
        }
        for (IFluxConnector f : devices) {
            f.getTransferHandler().onCycleEnd();
            this.bufferLimiter += f.getTransferHandler().getRequest();
        }
        ((NetworkStatistics)this.network_stats.getValue()).stopProfiling();
    }

    @Override
    public AccessLevel getMemberPermission(EntityPlayer player) {
        ISuperAdmin sa;
        if (FluxConfig.enableSuperAdmin && (sa = (ISuperAdmin)player.getCapability(Capabilities.SUPER_ADMIN, null)) != null && sa.getPermission()) {
            return AccessLevel.SUPER_ADMIN;
        }
        return ((List)this.network_players.getValue()).stream().collect(Collectors.toMap(NetworkMember::getPlayerUUID, NetworkMember::getAccessPermission)).getOrDefault(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()), ((SecurityType)((Object)this.network_security.getValue())).isEncrypted() ? AccessLevel.NONE : AccessLevel.USER);
    }

    @Override
    public void onRemoved() {
        this.getConnections(FluxLogicType.ANY).forEach(flux -> MinecraftForge.EVENT_BUS.post((Event)new FluxConnectionEvent.Disconnected((IFluxConnector)flux, this)));
        this.connections.clear();
        this.toAdd.clear();
        this.toRemove.clear();
        this.sortedPoints.clear();
        this.sortedPlugs.clear();
    }

    @Override
    public void queueConnectionAddition(IFluxConnector flux) {
        this.toAdd.add(flux);
        this.toRemove.remove(flux);
        this.addToLite(flux);
    }

    @Override
    public void queueConnectionRemoval(IFluxConnector flux, boolean chunkUnload) {
        this.toRemove.add(flux);
        this.toAdd.remove(flux);
        if (chunkUnload) {
            this.changeChunkLoaded(flux, false);
        } else {
            this.removeFromLite(flux);
        }
    }

    private void addToLite(IFluxConnector flux) {
        Optional<IFluxConnector> c = ((List)this.all_connectors.getValue()).stream().filter(f -> f.getCoords().equals(flux.getCoords())).findFirst();
        if (c.isPresent()) {
            this.changeChunkLoaded(flux, true);
        } else {
            FluxLiteConnector lite = new FluxLiteConnector(flux);
            ((List)this.all_connectors.getValue()).add(lite);
        }
    }

    private void removeFromLite(IFluxConnector flux) {
        ((List)this.all_connectors.getValue()).removeIf(f -> f.getCoords().equals(flux.getCoords()));
    }

    private void changeChunkLoaded(IFluxConnector flux, boolean chunkLoaded) {
        Optional<IFluxConnector> c = ((List)this.all_connectors.getValue()).stream().filter(f -> f.getCoords().equals(flux.getCoords())).findFirst();
        c.ifPresent(fluxConnector -> fluxConnector.setChunkLoaded(chunkLoaded));
    }

    @Override
    public void addNewMember(String name) {
        NetworkMember a = NetworkMember.createMemberByUsername(name);
        if (((List)this.network_players.getValue()).stream().noneMatch(f -> f.getPlayerUUID().equals(a.getPlayerUUID()))) {
            ((List)this.network_players.getValue()).add(a);
        }
    }

    @Override
    public void removeMember(UUID uuid) {
        ((List)this.network_players.getValue()).removeIf(p -> p.getPlayerUUID().equals(uuid) && !p.getAccessPermission().canDelete());
    }

    @Override
    public Optional<NetworkMember> getValidMember(UUID player) {
        return ((List)this.network_players.getValue()).stream().filter(f -> f.getPlayerUUID().equals(player)).findFirst();
    }

    public void markLiteSettingChanged(IFluxConnector flux) {
    }

    private void sortConnections() {
        this.sortedPlugs.clear();
        this.sortedPoints.clear();
        List<IFluxPlug> plugs = this.getConnections(FluxLogicType.PLUG);
        List<IFluxPoint> points = this.getConnections(FluxLogicType.POINT);
        plugs.forEach(p -> PriorityGroup.getOrCreateGroup(p.getLogicPriority(), this.sortedPlugs).getConnectors().add(p));
        points.forEach(p -> PriorityGroup.getOrCreateGroup(p.getLogicPriority(), this.sortedPoints).getConnectors().add(p));
        this.sortedPlugs.sort(Comparator.comparing(p -> -p.getPriority()));
        this.sortedPoints.sort(Comparator.comparing(p -> -p.getPriority()));
    }
}

