/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.block;

import com.mojang.authlib.GameProfile;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.common.block.BlockCore;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.item.ItemConfigurator;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

public abstract class BlockFluxCore
extends BlockCore {
    public static final PropertyBool CONNECTED = PropertyBool.func_177716_a((String)"connected");
    public AxisAlignedBB bounding = field_185505_j;

    public BlockFluxCore(String name) {
        super(name, FluxUtils.MACHINE, true);
        this.func_149711_c(0.3f);
        this.func_149752_b(1000000.0f);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (playerIn.func_184586_b(hand).func_77973_b() instanceof ItemConfigurator) {
            return false;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileFluxCore) {
            TileFluxCore fluxCore = (TileFluxCore)tileEntity;
            if (fluxCore.playerUsing.size() > 0) {
                TextComponentTranslation textComponents = new TextComponentTranslation("info.fluxnetworks.denied.occupy", new Object[0]);
                textComponents.func_150256_b().func_150227_a(Boolean.valueOf(true));
                textComponents.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
                playerIn.func_146105_b((ITextComponent)textComponents, true);
                return true;
            }
            if (fluxCore.canAccess(playerIn)) {
                playerIn.openGui((Object)FluxNetworks.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return true;
            }
        }
        TextComponentTranslation textComponents = new TextComponentTranslation("info.fluxnetworks.denied.access", new Object[0]);
        textComponents.func_150256_b().func_150227_a(Boolean.valueOf(true));
        textComponents.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
        playerIn.func_146105_b((ITextComponent)textComponents, true);
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            this.readDataFromStack(stack, pos, worldIn);
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof TileFluxCore) {
                TileFluxCore fluxCore = (TileFluxCore)tileEntity;
                if (placer instanceof EntityPlayer) {
                    fluxCore.playerUUID = EntityPlayer.func_146094_a((GameProfile)((EntityPlayer)placer).func_146103_bH());
                }
            }
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileFluxCore tileFluxCore;
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFluxCore && (tileFluxCore = (TileFluxCore)tile).canAccess(player)) {
            ItemStack stack = new ItemStack((Block)this, 1, this.func_180651_a(state));
            this.writeDataToStack(stack, pos, world);
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, stack);
            world.func_175698_g(pos);
            world.func_72838_d((Entity)entityItem);
            return true;
        }
        TextComponentTranslation textComponents = new TextComponentTranslation("info.fluxnetworks.denied.removal", new Object[0]);
        textComponents.func_150256_b().func_150227_a(Boolean.valueOf(true));
        textComponents.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
        player.func_146105_b((ITextComponent)textComponents, true);
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileFluxCore tile = (TileFluxCore)worldIn.func_175625_s(pos);
        state = state.func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(tile.connected));
        return state;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175713_t(pos);
    }

    protected void writeDataToStack(ItemStack stack, BlockPos pos, World world) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFluxCore) {
            TileFluxCore t = (TileFluxCore)tile;
            NBTTagCompound tag = stack.func_190925_c("FluxData");
            t.writeCustomNBT(tag, NBTType.TILE_DROP);
        }
    }

    protected void readDataFromStack(ItemStack stack, BlockPos pos, World world) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFluxCore && stack.func_77942_o()) {
            TileFluxCore t = (TileFluxCore)tile;
            NBTTagCompound tag = stack.func_179543_a("FluxData");
            if (tag != null) {
                t.readCustomNBT(tag, NBTType.TILE_DROP);
            }
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.bounding;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECTED});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CONNECTED) != false ? 1 : 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

