/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.popups;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.utils.Coord4D;
import sonar.fluxnetworks.client.gui.basic.GuiTextField;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.button.SimpleToggleButton;
import sonar.fluxnetworks.client.gui.button.SlidedSwitchButton;
import sonar.fluxnetworks.client.gui.button.TextboxButton;
import sonar.fluxnetworks.client.gui.popups.GuiPopCore;
import sonar.fluxnetworks.client.gui.tab.GuiTabConnections;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.PacketBatchEditing;

public class GuiPopConnectionEdit
extends GuiPopCore<GuiTabConnections> {
    public NormalButton apply;
    public TextboxButton fluxName;
    public TextboxButton priority;
    public TextboxButton limit;
    public SlidedSwitchButton surge;
    public SlidedSwitchButton unlimited;
    public SlidedSwitchButton chunkLoad;
    public SimpleToggleButton editName;
    public SimpleToggleButton editPriority;
    public SimpleToggleButton editLimit;
    public SimpleToggleButton editSurge;
    public SimpleToggleButton editUnlimited;
    public SimpleToggleButton editChunkLoad;
    public boolean batchMode;
    private List<SimpleToggleButton> toggleButtons = new ArrayList<SimpleToggleButton>();

    public GuiPopConnectionEdit(GuiTabConnections host, boolean batchMode, EntityPlayer player, INetworkConnector connector) {
        super(host, player, connector);
        this.batchMode = batchMode;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.toggleButtons.clear();
        this.popButtons.add(new NormalButton(FluxTranslate.CANCEL.t(), 40, 140, 36, 12, 11));
        this.apply = new NormalButton(FluxTranslate.APPLY.t(), 100, 140, 36, 12, 12).setUnclickable();
        this.popButtons.add(this.apply);
        int color = ((GuiTabConnections)this.host).network.getSetting(NetworkSettings.NETWORK_COLOR) | 0xFF000000;
        if (this.batchMode) {
            this.fluxName = TextboxButton.create(this, FluxTranslate.NAME.t() + ": ", 0, this.field_146289_q, 20, 30, 136, 12).setOutlineColor(color);
            this.fluxName.setMaxStringLength(24);
            this.priority = TextboxButton.create(this, FluxTranslate.PRIORITY.t() + ": ", 1, this.field_146289_q, 20, 47, 136, 12).setOutlineColor(color).setDigitsOnly();
            this.priority.setMaxStringLength(5);
            this.limit = TextboxButton.create(this, FluxTranslate.TRANSFER_LIMIT.t() + ": ", 2, this.field_146289_q, 20, 64, 136, 12).setOutlineColor(color).setDigitsOnly();
            this.limit.setMaxStringLength(9);
        } else {
            this.fluxName = TextboxButton.create(this, FluxTranslate.NAME.t() + ": ", 0, this.field_146289_q, 18, 30, 140, 12).setOutlineColor(color);
            this.fluxName.setMaxStringLength(24);
            this.priority = TextboxButton.create(this, FluxTranslate.PRIORITY.t() + ": ", 1, this.field_146289_q, 18, 47, 140, 12).setOutlineColor(color).setDigitsOnly();
            this.priority.setMaxStringLength(5);
            this.limit = TextboxButton.create(this, FluxTranslate.TRANSFER_LIMIT.t() + ": ", 2, this.field_146289_q, 18, 64, 140, 12).setOutlineColor(color).setDigitsOnly();
            this.limit.setMaxStringLength(9);
        }
        if (!this.batchMode) {
            this.fluxName.setText(((GuiTabConnections)this.host).singleConnection.getCustomName());
            this.priority.setText(String.valueOf(((GuiTabConnections)this.host).singleConnection.getLogicPriority()));
            this.limit.setText(String.valueOf(((GuiTabConnections)this.host).singleConnection.getLogicLimit()));
            this.surge = new SlidedSwitchButton(140, 82, 1, this.field_147003_i, this.field_147009_r, ((GuiTabConnections)this.host).singleConnection.getSurgeMode());
            this.unlimited = new SlidedSwitchButton(140, 94, 2, this.field_147003_i, this.field_147009_r, ((GuiTabConnections)this.host).singleConnection.getDisableLimit());
            this.popSwitches.add(this.surge);
            this.popSwitches.add(this.unlimited);
            if (!((GuiTabConnections)this.host).singleConnection.getConnectionType().isStorage()) {
                this.chunkLoad = new SlidedSwitchButton(140, 106, 3, this.field_147003_i, this.field_147009_r, ((GuiTabConnections)this.host).singleConnection.isForcedLoading());
                this.popSwitches.add(this.chunkLoad);
            }
        } else {
            this.priority.setText(String.valueOf(0));
            this.limit.setText(String.valueOf(0));
            this.editName = new SimpleToggleButton(10, 33, this.field_147003_i, this.field_147009_r, 0);
            this.editPriority = new SimpleToggleButton(10, 50, this.field_147003_i, this.field_147009_r, 1);
            this.editLimit = new SimpleToggleButton(10, 67, this.field_147003_i, this.field_147009_r, 2);
            this.editSurge = new SimpleToggleButton(10, 82, this.field_147003_i, this.field_147009_r, 3);
            this.editUnlimited = new SimpleToggleButton(10, 94, this.field_147003_i, this.field_147009_r, 4);
            this.editChunkLoad = new SimpleToggleButton(10, 106, this.field_147003_i, this.field_147009_r, 5);
            this.toggleButtons.add(this.editName);
            this.toggleButtons.add(this.editPriority);
            this.toggleButtons.add(this.editLimit);
            this.toggleButtons.add(this.editSurge);
            this.toggleButtons.add(this.editUnlimited);
            this.toggleButtons.add(this.editChunkLoad);
            this.surge = new SlidedSwitchButton(140, 82, 1, this.field_147003_i, this.field_147009_r, false);
            this.unlimited = new SlidedSwitchButton(140, 94, 2, this.field_147003_i, this.field_147009_r, false);
            this.chunkLoad = new SlidedSwitchButton(140, 106, 3, this.field_147003_i, this.field_147009_r, false);
            this.popSwitches.add(this.surge);
            this.popSwitches.add(this.unlimited);
            this.popSwitches.add(this.chunkLoad);
        }
        this.popBoxes.add(this.fluxName);
        this.popBoxes.add(this.priority);
        this.popBoxes.add(this.limit);
    }

    @Override
    public void func_146979_b(int mouseX, int mouseY) {
        this.drawRectWithBackground(8, 13, 150, 160, -855638017, -1342177280);
        super.func_146979_b(mouseX, mouseY);
        for (SlidedSwitchButton slidedSwitchButton : this.popSwitches) {
            slidedSwitchButton.drawButton(this.field_146297_k, mouseX, mouseY, this.field_147003_i, this.field_147009_r);
        }
        for (SimpleToggleButton simpleToggleButton : this.toggleButtons) {
            simpleToggleButton.drawButton(this.field_146297_k, mouseX, mouseY, this.field_147003_i, this.field_147009_r);
        }
        if (!this.batchMode) {
            this.func_73732_a(this.field_146289_q, FluxTranslate.SINGLE_EDIT.t(), 88, 17, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, ((GuiTabConnections)this.host).singleConnection.getCoords().getStringInfo(), 88, 122, 0xFFFFFF);
        } else {
            this.func_73732_a(this.field_146289_q, FluxTranslate.BATCH_EDIT.t(), 88, 17, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, FluxTranslate.EDITING.t() + " " + ((GuiTabConnections)this.host).batchConnections.size() + " " + FluxTranslate.CONNECTIONS.t(), 88, 122, 0xFFFFFF);
        }
        this.field_146289_q.func_78276_b(FluxTranslate.SURGE_MODE.t(), 20, 82, ((GuiTabConnections)this.host).network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        this.field_146289_q.func_78276_b(FluxTranslate.DISABLE_LIMIT.t(), 20, 94, ((GuiTabConnections)this.host).network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        if (this.batchMode || !((GuiTabConnections)this.host).singleConnection.getConnectionType().isStorage()) {
            this.field_146289_q.func_78276_b(FluxTranslate.CHUNK_LOADING.t(), 20, 106, ((GuiTabConnections)this.host).network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        }
        this.func_73732_a(this.field_146289_q, TextFormatting.RED + FluxNetworks.proxy.getFeedback(false).getInfo(), 88, 155, 0xFFFFFF);
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (NormalButton normalButton : this.popButtons) {
                ArrayList list;
                if (!normalButton.clickable || !normalButton.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
                if (normalButton.id == 11) {
                    ((GuiTabConnections)this.host).closePopUp();
                    return;
                }
                if (normalButton.id != 12) continue;
                boolean[] b2 = new boolean[]{true, true, true, true, true, true, false};
                if (this.batchMode) {
                    list = ((GuiTabConnections)this.host).batchConnections.stream().map(IFluxConnector::getCoords).collect(Collectors.toList());
                    b2[0] = this.editName.on;
                    b2[1] = this.editPriority.on;
                    b2[2] = this.editLimit.on;
                    b2[3] = this.editSurge.on;
                    b2[4] = this.editUnlimited.on;
                    b2[5] = this.editChunkLoad.on;
                } else {
                    list = Lists.newArrayList((Object[])new Coord4D[]{((GuiTabConnections)this.host).singleConnection.getCoords()});
                }
                NBTTagCompound tag = FluxUtils.getBatchEditingTag(this.fluxName, this.priority, this.limit, this.surge, this.unlimited, this.chunkLoad);
                PacketHandler.network.sendToServer((IMessage)new PacketBatchEditing.BatchEditingMessage(((GuiTabConnections)this.host).network.getNetworkID(), list, tag, b2));
                return;
            }
            for (SlidedSwitchButton slidedSwitchButton : this.popSwitches) {
                if (!slidedSwitchButton.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
                slidedSwitchButton.switchButton();
                if (this.batchMode) continue;
                this.apply.clickable = true;
            }
            for (SimpleToggleButton simpleToggleButton : this.toggleButtons) {
                if (!simpleToggleButton.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
                simpleToggleButton.on = !simpleToggleButton.on;
                this.apply.clickable = this.toggleButtons.stream().anyMatch(b -> b.on);
            }
        }
    }

    @Override
    public void func_73869_a(char c, int k) throws IOException {
        if (k == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(k)) {
            if (this.popBoxes.stream().noneMatch(GuiTextField::isFocused)) {
                ((GuiTabConnections)this.host).closePopUp();
            } else {
                this.popBoxes.stream().forEach(f -> f.setFocused(false));
            }
        }
        for (TextboxButton text : this.popBoxes) {
            if (!text.isFocused()) continue;
            text.textboxKeyTyped(c, k);
            if (this.batchMode) continue;
            this.apply.clickable = true;
        }
    }
}

