/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.button;

import net.minecraft.client.gui.FontRenderer;
import sonar.fluxnetworks.client.gui.basic.GuiTextField;
import sonar.fluxnetworks.client.gui.basic.ITextBoxButton;

public class TextboxButton
extends GuiTextField {
    private String origin;
    private String extraText;
    private int textWidth;
    private boolean digitsOnly;
    private boolean hexOnly;
    private ITextBoxButton gui;
    private int outlineColor = -4934476;
    private static final int boxColor = 0x20000000;

    public TextboxButton(ITextBoxButton gui, String text, int componentId, FontRenderer fontRenderer, int x, int y, int par5Width, int par6Height, int width) {
        super(componentId, fontRenderer, x + width, y, par5Width - width, par6Height);
        this.extraText = text;
        this.fontRenderer = fontRenderer;
        this.textWidth = width;
        this.gui = gui;
    }

    public static TextboxButton create(ITextBoxButton gui, String text, int id, FontRenderer fontRenderer, int x, int y, int width, int height) {
        return new TextboxButton(gui, text, id, fontRenderer, x, y, width, height, fontRenderer.func_78256_a(text));
    }

    public int getIntegerFromText(boolean nonNegative) {
        if (nonNegative) {
            return Math.max(Integer.parseInt(this.getText()), 0);
        }
        return Integer.parseInt(this.getText());
    }

    public long getLongFromText(boolean nonNegative) {
        if (nonNegative) {
            return Math.max(Long.parseLong(this.getText()), 0L);
        }
        return Long.parseLong(this.getText());
    }

    public int getIntegerFromHex() {
        return Integer.parseInt(this.getText(), 16);
    }

    @Override
    public void drawTextBox() {
        this.setEnableBackgroundDrawing(true);
        if (this.getVisible() && this.getEnableBackgroundDrawing()) {
            TextboxButton.func_73734_a((int)(this.x - this.textWidth - 1), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)this.y, (int)this.outlineColor);
            TextboxButton.func_73734_a((int)(this.x - this.textWidth - 1), (int)(this.y + this.height), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)this.outlineColor);
            TextboxButton.func_73734_a((int)(this.x - this.textWidth - 1), (int)this.y, (int)(this.x - this.textWidth), (int)(this.y + this.height), (int)this.outlineColor);
            TextboxButton.func_73734_a((int)(this.x + this.width), (int)this.y, (int)(this.x + this.width + 1), (int)(this.y + this.height), (int)this.outlineColor);
            TextboxButton.func_73734_a((int)(this.x - this.textWidth), (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)0x20000000);
        }
        this.setEnableBackgroundDrawing(false);
        this.x += 4;
        this.y += (this.height - 8) / 2;
        super.drawTextBox();
        this.fontRenderer.func_78276_b(this.extraText, this.x - this.textWidth, this.y, this.outlineColor);
        this.x -= 4;
        this.y -= (this.height - 8) / 2;
    }

    @Override
    public void writeText(String textToWrite) {
        char c;
        int i;
        if (this.digitsOnly) {
            for (i = 0; i < textToWrite.length(); ++i) {
                c = textToWrite.charAt(i);
                if (Character.isDigit(c)) continue;
                if (this.getText().isEmpty()) {
                    if (c == '-') continue;
                    return;
                }
                return;
            }
        }
        if (this.hexOnly) {
            for (i = 0; i < textToWrite.length(); ++i) {
                c = textToWrite.charAt(i);
                if (c != '-') continue;
                return;
            }
            String origin = this.getText();
            super.writeText(textToWrite);
            try {
                Integer.parseInt(this.getText(), 16);
            }
            catch (NumberFormatException ignored) {
                this.setText(origin);
            }
            return;
        }
        super.writeText(textToWrite);
    }

    @Override
    public void switchFocused(boolean isFocusedIn) {
        if (this.digitsOnly) {
            if (isFocusedIn) {
                this.origin = this.getText();
            } else {
                if (this.getText().isEmpty() || this.getText().equals("-")) {
                    this.setText("0");
                    return;
                }
                try {
                    Long.parseLong(this.getText());
                }
                catch (NumberFormatException ignored) {
                    this.setText(this.origin);
                }
            }
        }
        if (!isFocusedIn) {
            this.gui.onTextBoxChanged(this);
        }
    }

    public TextboxButton setOutlineColor(int color) {
        this.outlineColor = color;
        return this;
    }

    public TextboxButton setTextInvisible() {
        this.isTextInvisible = true;
        return this;
    }

    public TextboxButton setDigitsOnly() {
        this.digitsOnly = true;
        return this;
    }

    public TextboxButton setHexOnly() {
        this.hexOnly = true;
        return this;
    }
}

