/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.plugins;

import cofh.core.util.PluginCore;
import cofh.thermalfoundation.ThermalFoundation;
import net.minecraft.init.PotionTypes;
import net.minecraft.potion.PotionType;
import net.minecraftforge.fml.common.Loader;

public abstract class PluginTFBase
extends PluginCore {
    public PluginTFBase(String modId, String modName) {
        super(modId, modName);
    }

    public boolean preInit() {
        String category = "Plugins";
        String comment = "If TRUE, support for " + this.modName + " is enabled.";
        boolean bl = this.enable = ThermalFoundation.CONFIG.getConfiguration().getBoolean(this.modName, category, true, comment) && Loader.isModLoaded((String)this.modId);
        if (!this.enable) {
            return false;
        }
        this.initializeDelegate();
        return !this.error;
    }

    public boolean initialize() {
        if (!this.enable) {
            return false;
        }
        try {
            this.registerDelegate();
        }
        catch (Throwable t) {
            ThermalFoundation.LOG.error("Thermal Foundation: " + this.modName + " Plugin encountered an error:", t);
            this.error = true;
        }
        if (!this.error) {
            ThermalFoundation.LOG.info("Thermal Foundation: " + this.modName + " Plugin Enabled.");
        }
        return !this.error;
    }

    public void initializeDelegate() {
    }

    public void registerDelegate() {
    }

    public PotionType getPotionType(String baseName, String qualifier) {
        if (qualifier.isEmpty()) {
            return PotionType.func_185168_a((String)(this.modId + ":" + baseName));
        }
        PotionType ret = PotionType.func_185168_a((String)(this.modId + ":" + baseName + "_" + qualifier));
        if (ret == PotionTypes.field_185229_a) {
            ret = PotionType.func_185168_a((String)(this.modId + ":" + qualifier + "_" + baseName));
        }
        return ret;
    }
}

