/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.client.particle.Particles;
import slimeknights.tconstruct.library.entity.EntityProjectileBase;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.traits.AbstractProjectileTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.tools.ranged.TinkerRangedWeapons;

public class TraitEndspeed
extends AbstractProjectileTrait {
    public TraitEndspeed() {
        super("endspeed", 0xFFFFFF);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onBowShooting(TinkerToolEvent.OnBowShoot event) {
        if (TinkerUtil.hasTrait(TagUtil.getTagSafe(event.ammo), this.getModifierIdentifier())) {
            event.setBaseInaccuracy(event.getBaseInaccuracy() * 2.0f / 3.0f);
        }
    }

    @Override
    public void onLaunch(EntityProjectileBase projectileBase, World world, @Nullable EntityLivingBase shooter) {
        projectileBase.field_70159_w /= 10.0;
        projectileBase.field_70181_x /= 10.0;
        projectileBase.field_70179_y /= 10.0;
        projectileBase.func_189654_d(true);
    }

    @Override
    public void onProjectileUpdate(EntityProjectileBase projectile, World world, ItemStack toolStack) {
        double travelled;
        double lastParticle = 0.0;
        int ticks = projectile.field_70257_an;
        for (double sqrDistanceTraveled = 0.0; !projectile.field_70254_i && projectile.field_70257_an > 1 && sqrDistanceTraveled < 40.0; sqrDistanceTraveled += travelled) {
            double x = projectile.field_70165_t;
            double y = projectile.field_70163_u;
            double z = projectile.field_70161_v;
            projectile.field_70257_an = ticks;
            projectile.updateInAir();
            travelled = (x -= projectile.field_70165_t) * x + (y -= projectile.field_70163_u) * y + (z -= projectile.field_70161_v) * z;
            if (travelled < 0.001) break;
            if (!((lastParticle += travelled) > 0.3)) continue;
            TinkerRangedWeapons.proxy.spawnParticle(Particles.ENDSPEED, world, projectile.field_70165_t, projectile.field_70163_u, projectile.field_70161_v, new int[0]);
            lastParticle = 0.0;
        }
        projectile.field_70257_an = ticks;
    }

    @Override
    public void onMovement(EntityProjectileBase projectile, World world, double slowdown) {
        projectile.field_70159_w *= 1.0 / slowdown;
        projectile.field_70181_x *= 1.0 / slowdown;
        projectile.field_70179_y *= 1.0 / slowdown;
        projectile.field_70181_x -= projectile.getGravity() / 250.0;
    }
}

