/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.tools;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class Shovel
extends AoeToolCore {
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.field_151577_b, (Object)Material.field_151578_c, (Object)Material.field_151595_p, (Object)Material.field_151596_z, (Object)Material.field_151597_y, (Object)Material.field_151571_B, (Object[])new Material[]{Material.field_151568_F});

    public Shovel() {
        this(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.shovelHead), PartMaterialType.extra(TinkerTools.binding));
    }

    protected Shovel(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(Category.HARVEST);
        this.setHarvestLevel("shovel", 0);
    }

    @Override
    public boolean isEffective(IBlockState state) {
        return effective_materials.contains((Object)state.func_185904_a()) || ItemSpade.field_150916_c.contains(state.func_177230_c());
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block;
        ItemStack stack = player.func_184586_b(hand);
        if (ToolHelper.isBroken(stack)) {
            return EnumActionResult.FAIL;
        }
        EnumActionResult result = Items.field_151047_v.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        if (result == EnumActionResult.SUCCESS) {
            TinkerToolEvent.OnShovelMakePath.fireEvent(stack, player, world, pos);
        }
        if ((block = world.func_180495_p(pos).func_177230_c()) == Blocks.field_150349_c || block == Blocks.field_185774_da) {
            for (BlockPos aoePos : this.getAOEBlocks(stack, world, player, pos)) {
                if (ToolHelper.isBroken(stack)) break;
                EnumActionResult aoeResult = Items.field_151047_v.func_180614_a(player, world, aoePos, hand, facing, hitX, hitY, hitZ);
                if (result != EnumActionResult.SUCCESS) {
                    result = aoeResult;
                }
                if (aoeResult != EnumActionResult.SUCCESS) continue;
                TinkerToolEvent.OnShovelMakePath.fireEvent(stack, player, world, aoePos);
            }
        }
        return result;
    }

    @Override
    public double attackSpeed() {
        return 1.0;
    }

    @Override
    public float damagePotential() {
        return 0.9f;
    }

    @Override
    protected ToolNBT buildTagData(List<slimeknights.tconstruct.library.materials.Material> materials) {
        return this.buildDefaultTag(materials);
    }
}

