/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.ranged.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.client.BooleanItemPropertyGetter;
import slimeknights.tconstruct.library.client.crosshair.Crosshairs;
import slimeknights.tconstruct.library.client.crosshair.ICrosshair;
import slimeknights.tconstruct.library.client.crosshair.ICustomCrosshairUser;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.library.tools.ranged.BowCore;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.ranged.TinkerRangedWeapons;

public class CrossBow
extends BowCore
implements ICustomCrosshairUser {
    private static final String TAG_Loaded = "Loaded";
    protected static final ResourceLocation PROPERTY_IS_LOADED = new ResourceLocation("loaded");
    private ImmutableList<Item> boltMatches = null;

    public CrossBow() {
        super(PartMaterialType.crossbow(TinkerTools.toughToolRod), PartMaterialType.bow(TinkerTools.bowLimb), PartMaterialType.extra(TinkerTools.toughBinding), PartMaterialType.bowstring(TinkerTools.bowString));
        this.func_185043_a(PROPERTY_PULL_PROGRESS, this.pullProgressPropertyGetter);
        this.func_185043_a(PROPERTY_IS_PULLING, this.isPullingPropertyGetter);
        this.func_185043_a(PROPERTY_IS_LOADED, new BooleanItemPropertyGetter(){

            @Override
            public boolean applyIf(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && CrossBow.this.isLoaded(stack);
            }
        });
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addDefaultSubItems((List<ItemStack>)subItems, null, null, null, TinkerMaterials.string);
        }
    }

    @Override
    public float damagePotential() {
        return 0.8f;
    }

    @Override
    public double attackSpeed() {
        return 2.0;
    }

    @Override
    public float baseProjectileDamage() {
        return 3.0f;
    }

    @Override
    protected float baseProjectileSpeed() {
        return 7.0f;
    }

    @Override
    public float projectileDamageModifier() {
        return 1.3f;
    }

    @Override
    public int getDrawTime() {
        return 45;
    }

    public boolean isLoaded(ItemStack stack) {
        return TagUtil.getTagSafe(stack).func_74767_n(TAG_Loaded);
    }

    public void setLoaded(ItemStack stack, boolean isLoaded) {
        NBTTagCompound tag = TagUtil.getTagSafe(stack);
        tag.func_74757_a(TAG_Loaded, isLoaded);
        stack.func_77982_d(tag);
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.preventSlowDown(entityIn, 0.195f);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (!this.isLoaded(itemStackIn) || ToolHelper.isBroken(itemStackIn)) {
            return super.func_77659_a(worldIn, playerIn, hand);
        }
        super.func_77615_a(itemStackIn, worldIn, (EntityLivingBase)playerIn, 0);
        this.setLoaded(itemStackIn, false);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        int useTime;
        if (!ToolHelper.isBroken(stack) && entityLiving instanceof EntityPlayer && this.getDrawbackProgress(stack, useTime = this.func_77626_a(stack) - timeLeft) >= 1.0f) {
            Sounds.PlaySoundForPlayer((Entity)entityLiving, Sounds.crossbow_reload, 1.5f, 0.9f + field_77697_d.nextFloat() * 0.1f);
            this.setLoaded(stack, true);
        }
    }

    @Override
    public void playShootSound(float power, World world, EntityPlayer entityPlayer) {
        world.func_184148_a(null, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 0.5f + field_77697_d.nextFloat() * 0.1f);
    }

    @Override
    public ItemStack getAmmoToRender(ItemStack weapon, EntityLivingBase player) {
        if (!this.isLoaded(weapon)) {
            return ItemStack.field_190927_a;
        }
        return super.getAmmoToRender(weapon, player);
    }

    @Override
    protected List<Item> getAmmoItems() {
        if (this.boltMatches == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (TinkerRangedWeapons.bolt != null) {
                builder.add((Object)TinkerRangedWeapons.bolt);
            }
            this.boltMatches = builder.build();
        }
        return this.boltMatches;
    }

    @Override
    public ProjectileLauncherNBT buildTagData(List<Material> materials) {
        ProjectileLauncherNBT data = new ProjectileLauncherNBT();
        HandleMaterialStats body = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        ExtraMaterialStats bodyExtra = (ExtraMaterialStats)materials.get(0).getStatsOrUnknown("extra");
        HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        BowMaterialStats limb = (BowMaterialStats)materials.get(1).getStatsOrUnknown("bow");
        ExtraMaterialStats binding = (ExtraMaterialStats)materials.get(2).getStatsOrUnknown("extra");
        BowStringMaterialStats bowstring = (BowStringMaterialStats)materials.get(3).getStatsOrUnknown("bowstring");
        data.head(head);
        data.limb(limb);
        data.extra(binding, bodyExtra);
        data.handle(body);
        data.bowstring(bowstring);
        data.bonusDamage *= 1.5f;
        return data;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICrosshair getCrosshair(ItemStack itemStack, EntityPlayer player) {
        return Crosshairs.T;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getCrosshairState(ItemStack itemStack, EntityPlayer player) {
        if (this.isLoaded(itemStack)) {
            return 1.0f;
        }
        if (player.func_184607_cu() != itemStack) {
            return 0.0f;
        }
        return this.getDrawbackProgress(itemStack, (EntityLivingBase)player);
    }
}

