/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IToolMod;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.tools.modifiers.ToolModifier;

public class ModExtraTrait
extends ToolModifier {
    public static final List<ItemStack> EMBOSSMENT_ITEMS = ModExtraTrait.getEmbossmentItems();
    public static final String EXTRA_TRAIT_IDENTIFIER = "extratrait";
    private final Material material;
    public final Set<ToolCore> toolCores;
    private final Collection<ITrait> traits;

    public ModExtraTrait(Material material, Collection<ITrait> traits) {
        this(material, traits, ModExtraTrait.generateIdentifier(material, traits));
    }

    public ModExtraTrait(Material material, Collection<ITrait> traits, String customIdentifier) {
        super(EXTRA_TRAIT_IDENTIFIER + customIdentifier, material.materialTextColor);
        this.material = material;
        this.toolCores = new HashSet<ToolCore>();
        this.traits = traits;
        this.addAspects(new ExtraTraitAspect(), new ModifierAspect.SingleAspect(this), new ModifierAspect.DataAspect(this));
    }

    public <T extends Item> void addCombination(ToolCore toolCore, T toolPart) {
        this.toolCores.add(toolCore);
        ItemStack toolPartItem = ((IMaterialItem)toolPart).getItemstackWithMaterial(this.material);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(toolPartItem);
        stacks.addAll(EMBOSSMENT_ITEMS);
        ItemStack[] itemStacks = stacks.toArray(new ItemStack[0]);
        if (!this.matches(itemStacks).isPresent()) {
            this.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, itemStacks));
        }
    }

    public static String generateIdentifier(Material material, Collection<ITrait> traits) {
        String traitString = traits.stream().map(IToolMod::getIdentifier).sorted().collect(Collectors.joining());
        return material.getIdentifier() + traitString;
    }

    @Override
    public boolean canApplyTogether(Enchantment enchantment) {
        for (ITrait trait : this.traits) {
            if (trait.canApplyTogether(enchantment)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canApplyTogether(IToolMod otherModifier) {
        for (ITrait trait : this.traits) {
            if (trait.canApplyTogether(otherModifier) && otherModifier.canApplyTogether(trait)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canApplyCustom(ItemStack stack) throws TinkerGuiException {
        return stack.func_77973_b() instanceof ToolCore && this.toolCores.contains(stack.func_77973_b());
    }

    @Override
    public String getLocalizedName() {
        return Util.translate("modifier.%s.name", EXTRA_TRAIT_IDENTIFIER) + " (" + this.material.getLocalizedName() + ")";
    }

    @Override
    public String getLocalizedDesc() {
        return Util.translateFormatted(String.format("modifier.%s.desc", EXTRA_TRAIT_IDENTIFIER), this.material.getLocalizedName());
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        this.traits.forEach(trait -> ToolBuilder.addTrait(rootCompound, trait, this.color));
    }

    @Override
    public boolean hasTexturePerMaterial() {
        return true;
    }

    private static List<ItemStack> getEmbossmentItems() {
        ItemStack green = TinkerCommons.matSlimeCrystalGreen;
        ItemStack blue = TinkerCommons.matSlimeCrystalBlue;
        ItemStack red = TinkerCommons.matSlimeCrystalMagma;
        ItemStack expensive = new ItemStack(Blocks.field_150340_R);
        if (green == null) {
            green = new ItemStack(Items.field_151123_aH);
        }
        if (blue == null) {
            blue = new ItemStack(Items.field_151123_aH);
        }
        if (red == null) {
            red = new ItemStack(Items.field_151123_aH);
        }
        return ImmutableList.of((Object)green, (Object)blue, (Object)red, (Object)expensive);
    }

    private static class ExtraTraitAspect
    extends ModifierAspect {
        private ExtraTraitAspect() {
        }

        @Override
        public boolean canApply(ItemStack stack, ItemStack original) throws TinkerGuiException {
            NBTTagList modifierList = TagUtil.getModifiersTagList(original);
            for (int i = 0; i < modifierList.func_74745_c(); ++i) {
                NBTTagCompound tag = modifierList.func_150305_b(i);
                ModifierNBT data = ModifierNBT.readTag(tag);
                if (!data.identifier.startsWith(ModExtraTrait.EXTRA_TRAIT_IDENTIFIER)) continue;
                throw new TinkerGuiException(Util.translate("gui.error.already_has_extratrait", new Object[0]));
            }
            return true;
        }

        @Override
        public void updateNBT(NBTTagCompound root, NBTTagCompound modifierTag) {
        }
    }
}

