/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.model.BakedWrapper;
import slimeknights.tconstruct.library.client.model.ModelHelper;

@SideOnly(value=Side.CLIENT)
public class BakedColoredItemModel
extends BakedWrapper {
    public static final int MAX_SUPPORTED_TINT_INDEX = 7;
    private final ImmutableMap<EnumFacing, ImmutableList<BakedQuad>> coloredQuads;
    private final ImmutableList<BakedQuad> coloredDefaultQuads;

    public BakedColoredItemModel(ItemStack itemStack, IBakedModel parent) {
        super(parent);
        HashMap quads = null;
        boolean didColorQuads = false;
        for (int i = 0; i < 7; ++i) {
            int color = Minecraft.func_71410_x().getItemColors().func_186728_a(itemStack, i);
            if (color == -1) continue;
            if (quads == null) {
                quads = Maps.newHashMap();
                for (EnumFacing facing : ModelHelper.MODEL_SIDES) {
                    quads.put(facing, Lists.newArrayList((Iterable)parent.func_188616_a(null, facing, -1L)));
                }
            }
            float b = (float)(color & 0xFF) / 255.0f;
            float g = (float)(color >>> 8 & 0xFF) / 255.0f;
            float r = (float)(color >>> 16 & 0xFF) / 255.0f;
            float a = (float)(color >>> 24 & 0xFF) / 255.0f;
            if (a == 0.0f) {
                a = 1.0f;
            }
            for (EnumFacing facing : ModelHelper.MODEL_SIDES) {
                ListIterator<UnpackedBakedQuad> iter = ((List)quads.get(facing)).listIterator();
                while (iter.hasNext()) {
                    BakedQuad quad = (BakedQuad)iter.next();
                    if (quad.func_178211_c() != i) continue;
                    UnpackedBakedQuad.Builder quadBuilder = new UnpackedBakedQuad.Builder(quad.getFormat());
                    LightUtil.ItemConsumer itemConsumer = new LightUtil.ItemConsumer((IVertexConsumer)quadBuilder);
                    itemConsumer.setAuxColor(new float[]{r, g, b, a});
                    quad.pipe((IVertexConsumer)itemConsumer);
                    iter.set(quadBuilder.build());
                    didColorQuads = true;
                }
            }
        }
        if (didColorQuads) {
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (EnumFacing facing : EnumFacing.values()) {
                mapBuilder.put((Object)facing, (Object)ImmutableList.copyOf((Collection)((Collection)quads.get(facing))));
            }
            this.coloredQuads = mapBuilder.build();
            this.coloredDefaultQuads = ImmutableList.copyOf((Collection)((Collection)quads.get(null)));
        } else {
            this.coloredQuads = ImmutableMap.of();
            this.coloredDefaultQuads = ImmutableList.of();
        }
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (this.coloredQuads.isEmpty()) {
            return super.func_188616_a(state, side, rand);
        }
        if (side == null) {
            return this.coloredDefaultQuads;
        }
        return (List)this.coloredQuads.get((Object)side);
    }
}

