/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.tools.ranged.ProjectileCore;
import slimeknights.tconstruct.library.utils.TagUtil;

public class ProjectileNBT
extends ToolNBT {
    public float accuracy;

    public ProjectileNBT() {
        this.accuracy = 1.0f;
    }

    public ProjectileNBT(NBTTagCompound tag) {
        super(tag);
    }

    public ProjectileNBT shafts(ProjectileCore projectileCore, ArrowShaftMaterialStats ... shafts) {
        int dur = 0;
        float modifier = 0.0f;
        for (ArrowShaftMaterialStats shaft : shafts) {
            if (shaft == null) continue;
            dur += shaft.bonusAmmo;
            modifier += shaft.modifier;
        }
        this.durability = Math.round((float)this.durability * (modifier /= (float)shafts.length));
        this.durability += Math.round((float)(dur *= projectileCore.getDurabilityPerAmmo()) / (float)shafts.length);
        this.durability = Math.max(1, this.durability);
        return this;
    }

    public ProjectileNBT fletchings(FletchingMaterialStats ... fletchings) {
        float modifier = 0.0f;
        float accuracy = 0.0f;
        for (FletchingMaterialStats fletching : fletchings) {
            if (fletching == null) continue;
            modifier += fletching.modifier;
            accuracy += fletching.accuracy;
        }
        this.accuracy = Math.min(1.0f, Math.max(0.0f, accuracy /= (float)fletchings.length));
        this.durability = Math.round((float)this.durability * (modifier /= (float)fletchings.length));
        this.durability = Math.max(1, this.durability);
        return this;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        this.accuracy = tag.func_74760_g("Accuracy");
    }

    @Override
    public void write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74776_a("Accuracy", this.accuracy);
    }

    public static ProjectileNBT from(ItemStack itemStack) {
        return new ProjectileNBT(TagUtil.getToolTag(itemStack));
    }
}

