/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.events;

import net.minecraft.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import slimeknights.tconstruct.library.DryingRecipe;
import slimeknights.tconstruct.library.events.TinkerEvent;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;

@Cancelable
public abstract class TinkerRegisterEvent<T>
extends TinkerEvent {
    protected final T recipe;

    public TinkerRegisterEvent(T recipe) {
        this.recipe = recipe;
    }

    public T getRecipe() {
        return this.recipe;
    }

    public boolean fire() {
        return !MinecraftForge.EVENT_BUS.post((Event)this);
    }

    public static class EntityMeltingRegisterEvent
    extends TinkerRegisterEvent<Class<? extends Entity>> {
        protected final FluidStack fluidStack;
        protected FluidStack newFluidStack;

        public EntityMeltingRegisterEvent(Class<? extends Entity> entity, FluidStack fluidStack) {
            super(entity);
            this.fluidStack = fluidStack;
            this.newFluidStack = fluidStack;
        }

        public void setNewFluidStack(FluidStack fluidStack) {
            this.newFluidStack = fluidStack;
        }

        public FluidStack getNewFluidStack() {
            return this.newFluidStack;
        }

        public FluidStack getFluidStack() {
            return this.fluidStack;
        }
    }

    public static class SmelteryFuelRegisterEvent
    extends TinkerRegisterEvent<FluidStack> {
        private final int fuelDuration;

        public SmelteryFuelRegisterEvent(FluidStack recipe, int fuelDuration) {
            super(recipe);
            this.fuelDuration = fuelDuration;
        }

        public int getFuelDuration() {
            return this.fuelDuration;
        }
    }

    public static class BasinCastingRegisterEvent
    extends TinkerRegisterEvent<ICastingRecipe> {
        public BasinCastingRegisterEvent(ICastingRecipe recipe) {
            super(recipe);
        }
    }

    public static class TableCastingRegisterEvent
    extends TinkerRegisterEvent<ICastingRecipe> {
        public TableCastingRegisterEvent(ICastingRecipe recipe) {
            super(recipe);
        }
    }

    public static class AlloyRegisterEvent
    extends TinkerRegisterEvent<AlloyRecipe> {
        public AlloyRegisterEvent(AlloyRecipe recipe) {
            super(recipe);
        }
    }

    public static class MeltingRegisterEvent
    extends TinkerRegisterEvent<MeltingRecipe> {
        public MeltingRegisterEvent(MeltingRecipe recipe) {
            super(recipe);
        }
    }

    public static class DryingRackRegisterEvent
    extends TinkerRegisterEvent<DryingRecipe> {
        public DryingRackRegisterEvent(DryingRecipe recipe) {
            super(recipe);
        }
    }

    public static class ModifierRegisterEvent
    extends TinkerRegisterEvent<IModifier> {
        public ModifierRegisterEvent(IModifier recipe) {
            super(recipe);
        }
    }
}

