/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StringUtils {
    private static DecimalFormat formatter;

    private static DecimalFormat getFormatter() {
        if (formatter == null) {
            DecimalFormat lFormatter = new DecimalFormat("#,###.###");
            DecimalFormatSymbols smb = new DecimalFormatSymbols();
            smb.setGroupingSeparator(' ');
            lFormatter.setDecimalFormatSymbols(smb);
            formatter = lFormatter;
        }
        return formatter;
    }

    public static String getFormatted(String resourceName, String value, boolean showLabels) {
        if (showLabels) {
            return I18n.func_74837_a((String)resourceName, (Object[])new Object[]{value});
        }
        return value;
    }

    public static String getFormatted(String resourceName, double value, boolean showLabels) {
        return StringUtils.getFormatted(resourceName, StringUtils.getFormatter().format(value), showLabels);
    }

    public static String getFormattedKey(String resourceName, Object ... arguments) {
        return I18n.func_74837_a((String)resourceName, (Object[])arguments);
    }

    public static String getItemId(ItemStack stack) {
        return ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString();
    }

    @SideOnly(value=Side.CLIENT)
    public static String getItemName(ItemStack stack) {
        List list = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
        if (list.size() == 0) {
            return stack.func_77973_b().func_77658_a();
        }
        return (String)list.get(0);
    }
}

