/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.renderers;

import com.zuxelus.energycontrol.ClientTickHandler;
import com.zuxelus.energycontrol.api.IHasBars;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.renderers.TileEntityInfoPanelRenderer;
import com.zuxelus.energycontrol.tileentities.Screen;
import com.zuxelus.energycontrol.tileentities.TileEntityHoloPanel;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.math.BlockPos;

public class TileEntityHoloPanelRenderer
extends TileEntitySpecialRenderer<TileEntityHoloPanel> {
    public void render(TileEntityHoloPanel te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (partialTicks != -1.0f) {
            ClientTickHandler.holo_panels.add(te);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        switch (te.getFacing()) {
            case UP: {
                break;
            }
            case NORTH: {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.5f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)-1.0f);
                break;
            }
            case DOWN: {
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)-1.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.5f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)-0.5f, (float)0.0f);
            }
        }
        if (te.getPowered()) {
            List<PanelString> joinedData = te.getPanelStringList(false, te.getShowLabels());
            this.drawText(te, partialTicks, joinedData);
        }
        GlStateManager.func_179121_F();
    }

    private void drawText(TileEntityHoloPanel panel, float partialTicks, List<PanelString> joinedData) {
        Screen screen = panel.getScreen();
        BlockPos pos = panel.func_174877_v();
        int power = panel.getPower();
        float displayWidth = 0.875f;
        float displayHeight = (float)power - 0.125f;
        float dx = 0.0f;
        float dy = 0.0f;
        float dz = 0.0f;
        if (screen != null) {
            switch (panel.getFacing()) {
                case NORTH: {
                    dz = pos.func_177956_o() - screen.maxY - screen.minY + pos.func_177956_o();
                    dy = pos.func_177958_n() - screen.maxX - screen.minX + pos.func_177958_n();
                    dz = dz - (float)power + 1.0f;
                    displayWidth += (float)(screen.maxX - screen.minX);
                    break;
                }
                case SOUTH: {
                    dz = -(pos.func_177956_o() - screen.maxY - screen.minY + pos.func_177956_o());
                    dy = pos.func_177958_n() - screen.maxX - screen.minX + pos.func_177958_n();
                    dz = dz + (float)power - 1.0f;
                    displayWidth += (float)(screen.maxX - screen.minX);
                    break;
                }
                case WEST: {
                    dz = pos.func_177952_p() - screen.maxZ + pos.func_177952_p() - screen.minZ;
                    dy = pos.func_177956_o() - screen.maxY - screen.minY + pos.func_177956_o();
                    dy = dy - (float)power + 1.0f;
                    displayWidth += (float)(screen.maxZ - screen.minZ);
                    break;
                }
                case EAST: {
                    dz = pos.func_177952_p() - screen.maxZ + pos.func_177952_p() - screen.minZ;
                    dy = -(pos.func_177956_o() - screen.maxY - screen.minY + pos.func_177956_o());
                    dy = dy + (float)power - 1.0f;
                    displayWidth += (float)(screen.maxZ - screen.minZ);
                }
            }
        }
        GlStateManager.func_179109_b((float)(0.5f - dy / 2.0f), (float)(1.01f - dx / 2.0f), (float)(0.5f - dz / 2.0f));
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        switch (panel.getFacing()) {
            case NORTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        float imageWidth = 0.475f + (displayWidth - 0.875f) / 2.0f;
        float imageHeight = 0.5f + (float)(power - 1) / 2.0f;
        if (partialTicks == -1.0f) {
            IHasBars.drawTransparentRect(imageWidth, imageHeight, -imageWidth, -imageHeight, -1.0E-4f, 1084939741);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            IHasBars.drawTransparentRect(imageWidth, imageHeight, -imageWidth, -imageHeight, -1.0E-4f, 1084939741);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (joinedData != null) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(2.0E-4f * (float)(power + 1) / 2.0f));
            int colorHex = 0;
            if (panel.getColored()) {
                colorHex = panel.getColorText();
            }
            TileEntityInfoPanelRenderer.renderText(joinedData, displayWidth, displayHeight, colorHex, this.func_147498_b());
        }
    }
}

