/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.ITouchAction;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockLever;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardToggle
extends ItemCardBase
implements ITouchAction {
    private static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public ItemCardToggle() {
        super(13, "card_toggle");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        IBlockState state = world.func_180495_p(target);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150442_at || block instanceof BlockButton) {
            reader.setBoolean("value", (Boolean)state.func_177229_b((IProperty)POWERED));
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        PanelString line = new PanelString();
        if (reader.getBoolean("value").booleanValue()) {
            line.textCenter = "o";
            line.colorCenter = 65280;
        } else {
            line.textCenter = "o";
            line.colorCenter = 0xFF0000;
        }
        result.add(line);
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList(ItemStack stack) {
        return null;
    }

    @Override
    public boolean enableTouch(ItemStack stack) {
        return true;
    }

    @Override
    public boolean runTouchAction(World world, ICardReader reader, ItemStack stack) {
        BlockPos pos = reader.getTarget();
        if (pos == null) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150442_at) {
            state = state.func_177231_a((IProperty)POWERED);
            world.func_180501_a(pos, state, 3);
            world.func_175685_c(pos, state.func_177230_c(), false);
            EnumFacing enumfacing = ((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c();
            world.func_175685_c(pos.func_177972_a(enumfacing.func_176734_d()), state.func_177230_c(), false);
        }
        if (block instanceof BlockButton) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.TRUE), 3);
            world.func_175704_b(pos, pos);
            world.func_175685_c(pos, block, false);
            world.func_175685_c(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockButton.field_176387_N)).func_176734_d()), block, false);
            world.func_175684_a(pos, block, block.func_149738_a(world));
        }
        return false;
    }

    @Override
    public void renderImage(TextureManager manager, ICardReader reader) {
    }
}

