/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCardGalacticraft
extends ItemCardBase {
    public ItemCardGalacticraft() {
        super(23, "card_galacticraft");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        NBTTagCompound tag = CrossModLoader.getCrossMod("galacticraftplanets").getCardData(world, target);
        if (tag == null) {
            return CardState.NO_TARGET;
        }
        reader.reset();
        reader.copyFrom(tag);
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        if (reader.hasField("status") && (settings & 1) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelStatus", reader.getString("status"), showLabels));
        }
        if (reader.hasField("energy") && (settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelEnergy", reader.getDouble("energy"), "gJ", showLabels));
        }
        if (reader.hasField("capacity") && (settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCapacity", reader.getDouble("capacity"), "gJ", showLabels));
        }
        if (reader.hasField("output") && (settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getDouble("output"), "gJ/t", showLabels));
        }
        if (reader.hasField("diff") && (settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelDifference", reader.getDouble("diff"), "gJ/t", showLabels));
        }
        if (reader.hasField("oxygenPerTick") && (settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCollecting", reader.getDouble("oxygenPerTick"), showLabels));
        }
        if (reader.hasField("oxygenUse") && (settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelOxygenUse", reader.getDouble("oxygenUse"), showLabels));
        }
        if (reader.hasField("thermalStatus") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelThermalControl", reader.getString("thermalStatus"), showLabels));
        }
        if (reader.hasField("oxygenStored") && reader.hasField("oxygenCapacity") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelOxygen", String.format("%s / %s mB", reader.getInt("oxygenStored"), reader.getInt("oxygenCapacity")), showLabels));
        }
        if (reader.hasField("oilTank") && (settings & 0x10) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelOilTank", reader.getString("oilTank"), showLabels));
        }
        if (reader.hasField("fuelTank") && (settings & 0x10) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelFuel", reader.getString("fuelTank"), showLabels));
        }
        if (reader.hasField("waterTank") && (settings & 0x10) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelWater", reader.getString("waterTank"), showLabels));
        }
        if (reader.hasField("oxygenTank") && (settings & 0x10) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelOxygen", reader.getString("oxygenTank"), showLabels));
        }
        if (reader.hasField("hydrogenTank") && (settings & 0x10) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelHydrogen", reader.getString("hydrogenTank"), showLabels));
        }
        if (reader.hasField("valve") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelAtmosphericValve", reader.getInt("valve").intValue(), showLabels));
        }
        if (reader.hasField("dioxideTank") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCarbonDioxide", reader.getString("dioxideTank"), showLabels));
        }
        if (reader.hasField("methaneTank") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelMethane", reader.getString("methaneTank"), showLabels));
        }
        if (reader.hasField("carbon") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelFragmentedCarbon", reader.getInt("carbon").intValue(), showLabels));
        }
        if (reader.hasField("gasTankName") && (settings & 0x10) > 0) {
            result.add(new PanelString(I18n.func_135052_a((String)reader.getString("gasTankName"), (Object[])new Object[0]) + ": " + reader.getString("gasTank")));
        }
        if (reader.hasField("liquidTankName") && (settings & 0x10) > 0) {
            result.add(new PanelString(I18n.func_135052_a((String)reader.getString("liquidTankName"), (Object[])new Object[0]) + ": " + reader.getString("liquidTank")));
        }
        if (reader.hasField("liquidTank2Name") && (settings & 0x10) > 0) {
            result.add(new PanelString(I18n.func_135052_a((String)reader.getString("liquidTank2Name"), (Object[])new Object[0]) + ": " + reader.getString("liquidTank2")));
        }
        if (reader.hasField("oxygenDetected") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelOxygenDetected", reader.getString("oxygenDetected"), showLabels));
        }
        if (reader.hasField("boost") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelEnvironmentalBoost", reader.getDouble("boost"), showLabels));
        }
        if (reader.hasField("sunVisible") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelSunVisible", reader.getDouble("sunVisible"), showLabels));
        }
        if (reader.hasField("frequency") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelFrequency", reader.getInt("frequency").intValue(), showLabels));
        }
        if (reader.hasField("target") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelTarget", reader.getInt("target").intValue(), showLabels));
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList(ItemStack stack) {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(2);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelStatus", (Object[])new Object[0]), 1));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEnergy", (Object[])new Object[0]), 2));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOutput", (Object[])new Object[0]), 4));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelTank", (Object[])new Object[0]), 16));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOther", (Object[])new Object[0]), 64));
        return result;
    }
}

