/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.itemblock;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shadows.placebo.block.IEnumBlock;
import shadows.placebo.interfaces.IPropertyEnum;
import shadows.placebo.itemblock.ItemBlockBase;

public class ItemBlockEnum<E extends Enum<E>>
extends ItemBlockBase {
    protected final IEnumBlock<E> enumBlock;

    public ItemBlockEnum(IEnumBlock<E> enumBlock) {
        super((Block)enumBlock);
        this.enumBlock = enumBlock;
        this.func_77627_a(true);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block = world.func_180495_p(pos).func_177230_c();
        ItemStack stack = player.func_184586_b(hand);
        if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (!stack.func_190926_b() && player.func_175151_a(pos, facing, stack)) {
            IBlockState state = this.field_150939_a.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, stack.func_77960_j(), (EntityLivingBase)player, hand);
            if (this.mayPlaceInWorld(state, world, pos, false, facing, (Entity)player) && this.enumBlock.placeStateAt(state, world, pos)) {
                state = world.func_180495_p(pos);
                SoundType soundtype = state.func_177230_c().getSoundType(state, world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public int func_77647_b(int damage) {
        return MathHelper.func_76125_a((int)damage, (int)0, (int)(this.enumBlock.getTypes().size() - 1));
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() >= this.enumBlock.getTypes().size()) {
            return "invalid";
        }
        return this.func_77658_a() + "." + ((IPropertyEnum)((Object)((Enum)this.enumBlock.getTypes().get(stack.func_77960_j())))).func_176610_l();
    }

    public boolean mayPlaceInWorld(IBlockState state, World world, BlockPos pos, boolean skipCollisionCheck, EnumFacing sidePlaced, @Nullable Entity placer) {
        AxisAlignedBB axisalignedbb;
        IBlockState iblockstate1 = world.func_180495_p(pos);
        AxisAlignedBB axisAlignedBB = axisalignedbb = skipCollisionCheck ? null : state.func_185890_d((IBlockAccess)world, pos);
        if (axisalignedbb != Block.field_185506_k && !world.func_72917_a(axisalignedbb.func_186670_a(pos), placer)) {
            return false;
        }
        if (iblockstate1.func_185904_a() == Material.field_151594_q && state.func_177230_c() == Blocks.field_150467_bQ) {
            return true;
        }
        return iblockstate1.func_177230_c().func_176200_f((IBlockAccess)world, pos) && this.enumBlock.canPlaceBlockAt(state, world, pos, sidePlaced);
    }
}

