/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.distribution;

import cofh.cofhworld.data.biome.BiomeInfo;
import cofh.cofhworld.data.biome.BiomeInfoSet;
import cofh.cofhworld.world.IConfigurableFeatureGenerator;
import cofh.cofhworld.world.IFeatureGenerator;
import gnu.trove.set.hash.THashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public abstract class Distribution
implements IFeatureGenerator,
IConfigurableFeatureGenerator {
    public final String name;
    protected IConfigurableFeatureGenerator.GenRestriction biomeRestriction = IConfigurableFeatureGenerator.GenRestriction.NONE;
    protected IConfigurableFeatureGenerator.GenRestriction dimensionRestriction = IConfigurableFeatureGenerator.GenRestriction.NONE;
    public final boolean regen;
    protected boolean withVillage = true;
    protected int rarity;
    protected final BiomeInfoSet biomes = new BiomeInfoSet(1);
    protected final Set<Integer> dimensions = new THashSet();

    public Distribution(String name, boolean regen) {
        this.name = name;
        this.regen = regen;
    }

    @Override
    public Distribution setWithVillage(boolean inVillage) {
        this.withVillage = inVillage;
        return this;
    }

    @Override
    public Distribution setRarity(int rarity) {
        this.rarity = rarity;
        return this;
    }

    @Override
    public Distribution addBiome(BiomeInfo biome) {
        this.biomes.add(biome);
        return this;
    }

    @Override
    public Distribution addBiomes(BiomeInfoSet biomes) {
        this.biomes.addAll(biomes);
        return this;
    }

    @Override
    public Distribution addDimension(int dimID) {
        this.dimensions.add(dimID);
        return this;
    }

    @Override
    public Distribution setBiomeRestriction(IConfigurableFeatureGenerator.GenRestriction restriction) {
        this.biomeRestriction = restriction;
        return this;
    }

    @Override
    public Distribution setDimensionRestriction(IConfigurableFeatureGenerator.GenRestriction restriction) {
        this.dimensionRestriction = restriction;
        return this;
    }

    protected boolean canGenerateInBiome(World world, int x, int z, Random rand) {
        if (this.biomeRestriction != IConfigurableFeatureGenerator.GenRestriction.NONE) {
            Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
            return this.biomeRestriction == IConfigurableFeatureGenerator.GenRestriction.WHITELIST == this.biomes.contains(biome, rand);
        }
        return true;
    }

    @Override
    public final String getFeatureName() {
        return this.name;
    }

    @Override
    public boolean generateFeature(Random random, int chunkX, int chunkZ, World world, boolean hasVillage, boolean newGen) {
        if (!newGen && !this.regen) {
            return false;
        }
        if (hasVillage && !this.withVillage) {
            return false;
        }
        if (this.dimensionRestriction != IConfigurableFeatureGenerator.GenRestriction.NONE && this.dimensionRestriction == IConfigurableFeatureGenerator.GenRestriction.BLACKLIST == this.dimensions.contains(world.field_73011_w.getDimension())) {
            return false;
        }
        if (this.rarity > 1 && random.nextInt(this.rarity) != 0) {
            return false;
        }
        return this.generateFeature(random, chunkX * 16 + 8, chunkZ * 16 + 8, world);
    }

    @Override
    public abstract boolean generateFeature(Random var1, int var2, int var3, World var4);
}

