/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.api.backpack.variant;

import com.google.common.base.Preconditions;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackSpecialty;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraftforge.common.util.INBTSerializable;

public class BackpackSize
implements INBTSerializable<NBTTagByteArray> {
    private static final int MIN_COL = 1;
    private static final int MIN_ROW = 1;
    public static final BackpackSize MIN = new BackpackSize(1, 1, true);
    private static final int MAX_COL = 17;
    private static final int MAX_ROW = 7;
    public static final BackpackSize MAX = new BackpackSize(17, 7, true);
    @Nonnegative
    private int columns;
    @Nonnegative
    private int rows;

    public BackpackSize(@Nonnegative int columns, @Nonnegative int rows) {
        Preconditions.checkArgument((columns >= BackpackSize.MIN.columns ? 1 : 0) != 0, (Object)"Column count must be greater than the minimum");
        Preconditions.checkArgument((columns <= BackpackSize.MAX.columns ? 1 : 0) != 0, (Object)"Column count must be less than the maximum");
        Preconditions.checkArgument((rows >= BackpackSize.MIN.rows ? 1 : 0) != 0, (Object)"Row count must be greater than the minimum");
        Preconditions.checkArgument((rows <= BackpackSize.MAX.rows ? 1 : 0) != 0, (Object)"Row count must be less than the maximum");
        this.columns = columns;
        this.rows = rows;
    }

    public BackpackSize(@Nonnegative int columns, @Nonnegative int rows, boolean useBoundingConstructor) {
        Preconditions.checkArgument((columns >= 0 ? 1 : 0) != 0, (Object)"Column count must be non negative");
        Preconditions.checkArgument((columns <= 17 ? 1 : 0) != 0, (Object)"Column count must be less than the maximum");
        Preconditions.checkArgument((rows >= 0 ? 1 : 0) != 0, (Object)"Row count must be non negative");
        Preconditions.checkArgument((rows <= 7 ? 1 : 0) != 0, (Object)"Row count must be less than the maximum");
        this.columns = columns;
        this.rows = rows;
    }

    @Nonnegative
    public int getColumns() {
        return this.columns;
    }

    @Nonnull
    public BackpackSize setColumns(@Nonnegative int columns) {
        Preconditions.checkArgument((columns >= BackpackSize.MIN.columns ? 1 : 0) != 0, (Object)"Column count must be greater than the minimum");
        Preconditions.checkArgument((columns <= BackpackSize.MAX.columns ? 1 : 0) != 0, (Object)"Column count must be less than the maximum");
        this.columns = columns;
        return this;
    }

    @Nonnegative
    public int getRows() {
        return this.rows;
    }

    @Nonnull
    public BackpackSize setRows(@Nonnegative int rows) {
        Preconditions.checkArgument((rows >= BackpackSize.MIN.rows ? 1 : 0) != 0, (Object)"Row count must be greater than the minimum");
        Preconditions.checkArgument((rows <= BackpackSize.MAX.rows ? 1 : 0) != 0, (Object)"Row count must be less than the maximum");
        this.rows = rows;
        return this;
    }

    @Nonnull
    public NBTTagByteArray serializeNBT() {
        return new NBTTagByteArray(new byte[]{(byte)this.columns, (byte)this.rows});
    }

    public void deserializeNBT(@Nonnull NBTTagByteArray nbt) {
        this.columns = nbt.func_150292_c()[0];
        this.rows = nbt.func_150292_c()[1];
    }

    public boolean equals(@Nonnull Object obj) {
        if (!(obj instanceof BackpackSize)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BackpackSize size = (BackpackSize)obj;
        return size.columns == this.columns && size.rows == this.rows;
    }

    public String toString() {
        return this.columns + "x" + this.rows + " => " + this.getTotalSize();
    }

    @Nonnegative
    public int getTotalSize() {
        return this.columns * this.rows;
    }

    @Nonnull
    public BackpackSize applySizeModifierFromBackpackSpecialty(@Nonnull BackpackSpecialty specialty, @Nonnegative int colIncreaseAmount, @Nonnegative int rowIncreaseAmount) {
        Preconditions.checkNotNull((Object)((Object)specialty), (Object)"Specialty cannot be null");
        Preconditions.checkArgument((colIncreaseAmount >= 0 ? 1 : 0) != 0, (Object)"ColIncreaseAmount cannot be negative");
        Preconditions.checkArgument((rowIncreaseAmount >= 0 ? 1 : 0) != 0, (Object)"RowIncreaseAmount cannot be negative");
        if (specialty.equals((Object)BackpackSpecialty.STORAGE)) {
            return new BackpackSize(this.getColumns() + colIncreaseAmount, this.getRows() + rowIncreaseAmount);
        }
        return this;
    }

    @Nonnull
    public BackpackSize applyDefaultSizeModifierFromBackpackSpecialty(@Nonnull BackpackSpecialty specialty) {
        Preconditions.checkNotNull((Object)((Object)specialty), (Object)"Specialty cannot be null");
        if (this.getRows() == MAX.getRows()) {
            return this.applySizeModifierFromBackpackSpecialty(specialty, 2, 0);
        }
        return this.applySizeModifierFromBackpackSpecialty(specialty, 0, 1);
    }
}

