/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.api.configuration.Configurations;
import com.ldtteam.structurize.api.util.ChangeStorage;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.placementhandlers.IPlacementHandler;
import com.ldtteam.structurize.placementhandlers.PlacementHandlers;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.ScanToolOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class InstantStructurePlacer {
    protected final Structure structure;
    private boolean complete = false;

    public InstantStructurePlacer(Structure structure) {
        this.structure = structure;
    }

    public void removeStructure(@NotNull BlockPos pos) {
        this.structure.setLocalPosition(pos);
        for (int j = 0; j < this.structure.getHeight(); ++j) {
            for (int k = 0; k < this.structure.getLength(); ++k) {
                for (int i = 0; i < this.structure.getWidth(); ++i) {
                    BlockPos localPos = new BlockPos(i, j, k);
                    BlockPos worldPos = pos.func_177971_a((Vec3i)localPos);
                    if (this.structure.getWorld().func_175623_d(worldPos)) continue;
                    this.structure.getWorld().func_175698_g(worldPos);
                }
            }
        }
    }

    public void setupStructurePlacement(@NotNull BlockPos pos, boolean complete, EntityPlayerMP player) {
        this.structure.setLocalPosition(pos);
        this.complete = complete;
        this.structure.setPosition(pos);
        Manager.addToQueue(new ScanToolOperation(this, (EntityPlayer)player));
    }

    public BlockPos placeStructure(World world, ChangeStorage storage, BlockPos inputPos) {
        BlockPos worldPos;
        this.structure.setLocalPosition(inputPos);
        ArrayList<BlockPos> delayedBlocks = new ArrayList<BlockPos>();
        BlockPos endPos = new BlockPos(this.structure.getWidth(), this.structure.getHeight(), this.structure.getLength());
        BlockPos currentPos = inputPos;
        int count = 0;
        for (int y = currentPos.func_177956_o(); y < endPos.func_177956_o(); ++y) {
            for (int x = currentPos.func_177958_n(); x < endPos.func_177958_n(); ++x) {
                for (int z = currentPos.func_177952_p(); z < endPos.func_177952_p(); ++z) {
                    BlockPos localPos = new BlockPos(x, y, z);
                    IBlockState localState = this.structure.getBlockState(localPos);
                    if (localState == null) continue;
                    Block localBlock = localState.func_177230_c();
                    worldPos = this.structure.getPosition().func_177971_a((Vec3i)localPos);
                    if (localBlock == ModBlocks.blockSubstitution && !this.complete || localBlock instanceof IAnchorBlock) continue;
                    ++count;
                    storage.addPositionStorage(worldPos, world);
                    if (localState.func_185904_a().func_76220_a()) {
                        this.handleBlockPlacement(world, worldPos, localState, this.complete, this.structure.getTileEntityData(localPos));
                    } else {
                        delayedBlocks.add(localPos);
                    }
                    if (count < Configurations.gameplay.maxOperationsPerTick) continue;
                    this.handleDelayedBlocks(delayedBlocks, storage, world);
                    return new BlockPos(x, y, z);
                }
                currentPos = new BlockPos(x, y, 0);
            }
            currentPos = new BlockPos(0, y, 0);
        }
        this.handleDelayedBlocks(delayedBlocks, storage, world);
        for (NBTTagCompound compound : this.structure.getEntityData()) {
            if (compound == null) continue;
            try {
                BlockPos pos = this.structure.getPosition();
                Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)world);
                entity.func_184221_a(UUID.randomUUID());
                worldPos = entity.func_174791_d().func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                if (entity instanceof EntityHanging) {
                    entity.field_70165_t = worldPos.field_72450_a;
                    entity.field_70163_u = worldPos.field_72448_b;
                    entity.field_70161_v = worldPos.field_72449_c;
                    BlockPos hanging = ((EntityHanging)entity).func_174857_n();
                    entity.func_70107_b((double)(hanging.func_177958_n() + pos.func_177958_n()), (double)(hanging.func_177956_o() + pos.func_177956_o()), (double)(hanging.func_177952_p() + pos.func_177952_p()));
                } else {
                    entity.func_70107_b(worldPos.field_72450_a, worldPos.field_72448_b, worldPos.field_72449_c);
                }
                world.func_72838_d(entity);
                storage.addToBeKilledEntity(entity);
            }
            catch (RuntimeException e) {
                Log.getLogger().info("Couldn't restore entitiy", (Throwable)e);
            }
        }
        return null;
    }

    private void handleDelayedBlocks(List<BlockPos> delayedBlocks, ChangeStorage storage, World world) {
        for (BlockPos coords : delayedBlocks) {
            IBlockState localState = this.structure.getBlockState(coords);
            BlockPos newWorldPos = this.structure.getPosition().func_177971_a((Vec3i)coords);
            storage.addPositionStorage(coords, world);
            BlockInfo info = this.structure.getBlockInfo(coords);
            this.handleBlockPlacement(world, newWorldPos, localState, this.complete, info == null ? null : info.getTileEntityData());
        }
    }

    public void handleBlockPlacement(World world, BlockPos pos, IBlockState localState, boolean complete, NBTTagCompound tileEntityData) {
        for (IPlacementHandler handlers : PlacementHandlers.handlers) {
            if (!handlers.canHandle(world, pos, localState)) continue;
            handlers.handle(world, pos, localState, tileEntityData, complete, this.structure.getPosition(), this.structure.getSettings());
            return;
        }
    }

    public boolean checkForFreeSpace(@NotNull BlockPos pos) {
        this.structure.setLocalPosition(pos);
        for (int j = 0; j < this.structure.getHeight(); ++j) {
            for (int k = 0; k < this.structure.getLength(); ++k) {
                for (int i = 0; i < this.structure.getWidth(); ++i) {
                    BlockPos localPos = new BlockPos(i, j, k);
                    BlockPos worldPos = pos.func_177971_a((Vec3i)localPos);
                    if (worldPos.func_177956_o() <= pos.func_177956_o() && !this.structure.getWorld().func_180495_p(worldPos.func_177977_b()).func_185904_a().func_76220_a()) {
                        return false;
                    }
                    IBlockState worldState = this.structure.getWorld().func_180495_p(worldPos);
                    if (worldState.func_177230_c() == Blocks.field_150357_h) {
                        return false;
                    }
                    if (worldPos.func_177956_o() <= pos.func_177956_o() || worldState.func_177230_c() == Blocks.field_150350_a) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }
}

