/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.ItemUtils;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.tile.IDyeableKitchen;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BlockKitchen
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", input -> input != EnumFacing.DOWN && input != EnumFacing.UP);
    public static final PropertyBool LOWERED = PropertyBool.func_177716_a((String)"lowered");
    public static final PropertyBool FLIPPED = PropertyBool.func_177716_a((String)"flipped");
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);
    private static final AxisAlignedBB BOUNDING_BOX_X = new AxisAlignedBB(0.03125, 0.0, 0.0, 0.96875, 0.9375, 1.0);
    private static final AxisAlignedBB BOUNDING_BOX_Z = new AxisAlignedBB(0.0, 0.0, 0.03125, 1.0, 0.9375, 0.96875);

    protected BlockKitchen(Material material) {
        super(material);
        this.func_149647_a(CookingForBlockheads.creativeTab);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X) {
            return BOUNDING_BOX_X;
        }
        return BOUNDING_BOX_Z;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.cookingforblockheads:multiblock_kitchen", (Object[])new Object[0]));
    }

    public static boolean shouldBlockRenderLowered(IBlockAccess world, BlockPos pos) {
        Block blockBelow = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return blockBelow == ModBlocks.corner || blockBelow == ModBlocks.counter;
    }

    public boolean shouldBePlacedFlipped(BlockPos pos, EnumFacing facing, EntityLivingBase placer) {
        double dir = 0.0;
        if (facing.func_176740_k() == EnumFacing.Axis.Z) {
            dir = (double)((float)pos.func_177958_n() + 0.5f) - placer.field_70165_t;
            dir *= -1.0;
        } else if (facing.func_176740_k() == EnumFacing.Axis.X) {
            dir = (double)((float)pos.func_177952_p() + 0.5f) - placer.field_70161_v;
        }
        boolean flipped = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? dir < 0.0 : dir > 0.0;
        return flipped;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        IItemHandler itemHandler;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && (itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            ItemUtils.dropItemHandlerItems(world, pos, itemHandler);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IDyeableKitchen) {
            IDyeableKitchen dyeable = (IDyeableKitchen)tileEntity;
            if (dyeable.getDyedColor() == color) {
                return false;
            }
            dyeable.setDyedColor(color);
        }
        return true;
    }
}

