/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.cookingforblockheads.ModConfig;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.network.NetworkHandler;
import net.blay09.mods.cookingforblockheads.network.message.MessageSyncedEffect;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CowJarHandler {
    private static final List<Class<? extends EntityLivingBase>> additionalCowClasses = Lists.newArrayList();

    public static void registerCowClass(Class<?> clazz) {
        additionalCowClasses.add(clazz);
    }

    @SubscribeEvent
    public void onEntityDamage(LivingAttackEvent event) {
        if (!ModConfig.general.cowJarEnabled) {
            return;
        }
        if (event.getSource() == DamageSource.field_82728_o && this.isCow(event.getEntityLiving())) {
            BlockPos pos = event.getEntity().func_180425_c().func_177977_b();
            IBlockState blockBelow = event.getEntity().func_130014_f_().func_180495_p(pos);
            if (blockBelow.func_177230_c() == ModBlocks.milkJar) {
                event.getEntity().func_130014_f_().func_175656_a(pos, ModBlocks.cowJar.func_176223_P());
            }
            NetworkHandler.instance.sendToAllAround((IMessage)new MessageSyncedEffect(pos, MessageSyncedEffect.Type.COW_IN_A_JAR), new NetworkRegistry.TargetPoint(event.getEntity().field_70170_p.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 32.0));
            event.getEntity().func_70106_y();
            event.setCanceled(true);
        }
    }

    public boolean isCow(EntityLivingBase entity) {
        if (entity instanceof EntityCow) {
            return true;
        }
        for (Class<? extends EntityLivingBase> clazz : additionalCowClasses) {
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        String registryName = EntityList.func_75621_b((Entity)entity);
        return registryName != null && registryName.contains("cow");
    }
}

