/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.interactionhandling.CustomITextComponentSerializer;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class TriggerServerResponseHandlerMessage
extends AbstractMessage<TriggerServerResponseHandlerMessage, IMessage> {
    private int colonyId;
    private int citizenId;
    private ITextComponent key;
    private ITextComponent response;
    private int dimension;

    public TriggerServerResponseHandlerMessage() {
    }

    public TriggerServerResponseHandlerMessage(int colonyId, int citizenId, int dimension, @NotNull ITextComponent key, @NotNull ITextComponent response) {
        this.colonyId = colonyId;
        this.citizenId = citizenId;
        this.dimension = dimension;
        this.key = key;
        this.response = response;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.citizenId = buf.readInt();
        this.dimension = buf.readInt();
        this.key = CustomITextComponentSerializer.fromJsonLenient(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.response = CustomITextComponentSerializer.fromJsonLenient(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.citizenId);
        buf.writeInt(this.dimension);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)CustomITextComponentSerializer.componentToJson(this.key));
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)CustomITextComponentSerializer.componentToJson(this.response));
    }

    @Override
    public void messageOnServerThread(TriggerServerResponseHandlerMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null && colony.getPermissions().hasPermission((EntityPlayer)player, Action.ACCESS_HUTS)) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            ICitizenData citizenData = colony.getCitizenManager().getCitizen(message.citizenId);
            if (citizenData != null) {
                citizenData.onResponseTriggered(message.key, message.response, (World)player.func_71121_q());
            }
        }
    }
}

