/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class CircleParticleEffectMessage
extends AbstractMessage<CircleParticleEffectMessage, IMessage> {
    private static final Random RAND = new Random();
    private EnumParticleTypes type;
    private double posX;
    private double posY;
    private double posZ;
    private int stage;

    public CircleParticleEffectMessage() {
    }

    public CircleParticleEffectMessage(Vec3d pos, EnumParticleTypes type, int stage) {
        this.posX = pos.field_72450_a;
        this.posY = pos.field_72448_b - 0.5;
        this.posZ = pos.field_72449_c;
        this.stage = stage;
        this.type = type;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.stage = buf.readInt();
        this.type = EnumParticleTypes.values()[buf.readInt()];
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeInt(this.stage);
        buf.writeInt(this.type.ordinal());
    }

    @Override
    protected void messageOnClientThread(CircleParticleEffectMessage message, MessageContext ctx) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        double x = 1.0 * Math.cos((double)message.stage * 45.0) + message.posX;
        double z = 1.0 * Math.sin((double)message.stage * 45.0) + message.posZ;
        for (int i = 0; i < 5; ++i) {
            Vec3d randomPos = new Vec3d(RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1);
            Vec3d randomOffset = new Vec3d((RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1);
            world.func_175688_a(message.type, x + randomOffset.field_72450_a, message.posY + randomOffset.field_72448_b, z + randomOffset.field_72449_c, randomPos.field_72450_a, randomPos.field_72448_b + 0.05, randomPos.field_72449_c, new int[0]);
        }
    }
}

